/*
 * Decompiled with CFR 0.152.
 */
package net.essentialsx.discordlink.listeners;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.utils.FormatUtil;
import net.essentialsx.api.v2.events.AsyncUserDataLoadEvent;
import net.essentialsx.api.v2.events.UserMailEvent;
import net.essentialsx.api.v2.events.discord.DiscordMessageEvent;
import net.essentialsx.api.v2.events.discordlink.DiscordLinkStatusChangeEvent;
import net.essentialsx.api.v2.services.discord.MessageType;
import net.essentialsx.discord.util.MessageUtil;
import net.essentialsx.discordlink.DiscordLinkSettings;
import net.essentialsx.discordlink.EssentialsDiscordLink;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class LinkBukkitListener
implements Listener {
    private final EssentialsDiscordLink ess;

    public LinkBukkitListener(EssentialsDiscordLink ess) {
        this.ess = ess;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMail(UserMailEvent event) {
        if (!this.ess.getSettings().isRelayMail()) {
            return;
        }
        String discordId = this.ess.getLinkManager().getDiscordId(event.getRecipient().getBase().getUniqueId());
        if (discordId == null) {
            return;
        }
        String sanitizedName = MessageUtil.sanitizeDiscordMarkdown((String)event.getMessage().getSenderUsername());
        String sanitizedMessage = MessageUtil.sanitizeDiscordMarkdown((String)FormatUtil.stripFormat((String)event.getMessage().getMessage()));
        this.ess.getApi().getMemberById(discordId).thenAccept(member -> member.sendPrivateMessage(I18n.tl((String)"discordMailLine", (Object[])new Object[]{sanitizedName, sanitizedMessage})));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onConnect(AsyncPlayerPreLoginEvent event) {
        if (this.ess.getSettings().getLinkPolicy() != DiscordLinkSettings.LinkPolicy.KICK) {
            return;
        }
        if (!this.ess.getLinkManager().isLinked(event.getUniqueId())) {
            String code;
            try {
                code = this.ess.getLinkManager().createCode(event.getUniqueId());
            }
            catch (IllegalArgumentException e) {
                code = e.getMessage();
            }
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, I18n.tl((String)"discordLinkLoginKick", (Object[])new Object[]{"/link " + code, this.ess.getApi().getInviteUrl()}));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInteract(PlayerInteractEvent event) {
        if (this.ess.getSettings().getLinkPolicy() != DiscordLinkSettings.LinkPolicy.FREEZE) {
            return;
        }
        if (!this.ess.getLinkManager().isLinked(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (this.ess.getSettings().getLinkPolicy() != DiscordLinkSettings.LinkPolicy.FREEZE) {
            return;
        }
        if (!this.ess.getLinkManager().isLinked(event.getPlayer().getUniqueId())) {
            String code;
            event.setCancelled(true);
            try {
                code = this.ess.getLinkManager().createCode(event.getPlayer().getUniqueId());
            }
            catch (IllegalArgumentException e) {
                code = e.getMessage();
            }
            event.getPlayer().sendMessage(I18n.tl((String)"discordLinkLoginPrompt", (Object[])new Object[]{"/link " + code, this.ess.getApi().getInviteUrl()}));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onChat(AsyncPlayerChatEvent event) {
        if (this.ess.getSettings().getLinkPolicy() != DiscordLinkSettings.LinkPolicy.FREEZE) {
            return;
        }
        if (!this.ess.getLinkManager().isLinked(event.getPlayer().getUniqueId())) {
            String code;
            event.setCancelled(true);
            try {
                code = this.ess.getLinkManager().createCode(event.getPlayer().getUniqueId());
            }
            catch (IllegalArgumentException e) {
                code = e.getMessage();
            }
            event.getPlayer().sendMessage(I18n.tl((String)"discordLinkLoginPrompt", (Object[])new Object[]{"/link " + code, this.ess.getApi().getInviteUrl()}));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onUserDataLoad(AsyncUserDataLoadEvent event) {
        if (this.ess.getSettings().getLinkPolicy() != DiscordLinkSettings.LinkPolicy.FREEZE) {
            return;
        }
        if (!this.ess.getLinkManager().isLinked(event.getUser().getBase().getUniqueId())) {
            String code;
            event.getUser().setFreeze(true);
            try {
                code = this.ess.getLinkManager().createCode(event.getUser().getBase().getUniqueId());
            }
            catch (IllegalArgumentException e) {
                code = e.getMessage();
            }
            event.getUser().sendMessage(I18n.tl((String)"discordLinkLoginPrompt", (Object[])new Object[]{"/link " + code, this.ess.getApi().getInviteUrl()}));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDiscordMessage(DiscordMessageEvent event) {
        if (this.ess.getSettings().isBlockUnlinkedChat() && event.getType() == MessageType.DefaultTypes.CHAT && !this.ess.getLinkManager().isLinked(event.getUUID())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onUserLinkStatusChange(DiscordLinkStatusChangeEvent event) {
        String code;
        if (event.isLinked() || this.ess.getSettings().getLinkPolicy() == DiscordLinkSettings.LinkPolicy.NONE) {
            event.getUser().setFreeze(false);
            return;
        }
        try {
            code = this.ess.getLinkManager().createCode(event.getUser().getBase().getUniqueId());
        }
        catch (IllegalArgumentException e) {
            code = e.getMessage();
        }
        String finalCode = code;
        switch (this.ess.getSettings().getLinkPolicy()) {
            case KICK: {
                Runnable kickTask = () -> event.getUser().getBase().kickPlayer(I18n.tl((String)"discordLinkLoginKick", (Object[])new Object[]{"/link " + finalCode, this.ess.getApi().getInviteUrl()}));
                if (Bukkit.isPrimaryThread()) {
                    kickTask.run();
                    break;
                }
                this.ess.getEss().scheduleSyncDelayedTask(kickTask);
                break;
            }
            case FREEZE: {
                event.getUser().sendMessage(I18n.tl((String)"discordLinkLoginPrompt", (Object[])new Object[]{"/link " + code, this.ess.getApi().getInviteUrl()}));
                event.getUser().setFreeze(true);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

