/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import java.util.Collection;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.player.UserAudience;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.SpigotVersionSpecificMethods;
import org.geysermc.floodgate.util.WhitelistUtils;

public final class SpigotCommandUtil
extends CommandUtil {
    private final Server server;
    private final SpigotVersionSpecificMethods versionSpecificMethods;
    private UserAudience console;

    public SpigotCommandUtil(LanguageManager manager, Server server, FloodgateApi api, SpigotVersionSpecificMethods versionSpecificMethods) {
        super(manager, api);
        this.server = server;
        this.versionSpecificMethods = versionSpecificMethods;
    }

    @Override
    public @NonNull UserAudience getUserAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof CommandSender)) {
            throw new IllegalArgumentException("Source has to be a CommandSender!");
        }
        CommandSender source = (CommandSender)sourceObj;
        if (!(source instanceof Player)) {
            if (this.console != null) {
                return this.console;
            }
            this.console = new UserAudience.ConsoleAudience(source, this);
            return this.console;
        }
        Player player = (Player)source;
        UUID uuid = player.getUniqueId();
        String username = player.getName();
        String locale = this.versionSpecificMethods.getLocale(player);
        return new UserAudience.PlayerAudience(uuid, username, locale, source, this, true);
    }

    @Override
    protected String getUsernameFromSource(@NonNull Object source) {
        return ((Player)source).getName();
    }

    @Override
    protected UUID getUuidFromSource(@NonNull Object source) {
        return ((Player)source).getUniqueId();
    }

    @Override
    protected Collection<?> getOnlinePlayers() {
        return this.server.getOnlinePlayers();
    }

    @Override
    public Object getPlayerByUuid(@NonNull UUID uuid) {
        Player player = this.server.getPlayer(uuid);
        return player != null ? player : uuid;
    }

    @Override
    public Object getPlayerByUsername(@NonNull String username) {
        Player player = this.server.getPlayer(username);
        return player != null ? player : username;
    }

    @Override
    public boolean hasPermission(Object player, String permission) {
        return ((CommandSender)player).hasPermission(permission);
    }

    @Override
    public void sendMessage(Object target, String message) {
        ((CommandSender)target).sendMessage(message);
    }

    @Override
    public void kickPlayer(Object player, String message) {
        if (player instanceof Player) {
            this.versionSpecificMethods.schedule(() -> ((Player)player).kickPlayer(message), 0L);
        }
    }

    @Override
    public boolean whitelistPlayer(UUID uuid, String username) {
        return WhitelistUtils.addPlayer(uuid, username, this.versionSpecificMethods);
    }

    @Override
    public boolean removePlayerFromWhitelist(UUID uuid, String username) {
        return WhitelistUtils.removePlayer(uuid, username, this.versionSpecificMethods);
    }
}

