/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

public final class BrigadierUtils {
    public static boolean isAllowedInUnquotedString(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '-' || c == '.' || c == '+';
    }

    public static String escapeIfRequired(String input, boolean quoted) {
        if (quoted) {
            return BrigadierUtils.escape(input);
        }
        for (char c : input.toCharArray()) {
            if (BrigadierUtils.isAllowedInUnquotedString(c)) continue;
            return "\"" + input + "\"";
        }
        return input;
    }

    private static String escape(String input) {
        StringBuilder result = new StringBuilder("\"");
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\' || c == '\"') {
                result.append('\\');
            }
            result.append(c);
        }
        result.append("\"");
        return result.toString();
    }
}

