/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.pluginmessage;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.event.EventBus;
import org.geysermc.floodgate.event.skin.SkinApplyEventImpl;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ReflectionUtils;
import org.geysermc.floodgate.util.SpigotVersionSpecificMethods;

@Singleton
public final class SpigotSkinApplier
implements SkinApplier {
    @Inject
    private SpigotVersionSpecificMethods versionSpecificMethods;
    @Inject
    private EventBus eventBus;

    @Override
    public void applySkin(@NonNull FloodgatePlayer floodgatePlayer, @NonNull SkinApplyEvent.SkinData skinData) {
        this.applySkin0(floodgatePlayer, skinData, true);
    }

    private void applySkin0(FloodgatePlayer floodgatePlayer, SkinApplyEvent.SkinData skinData, boolean firstTry) {
        Player player = Bukkit.getPlayer((UUID)floodgatePlayer.getCorrectUniqueId());
        if (player == null) {
            if (firstTry) {
                this.versionSpecificMethods.schedule(() -> this.applySkin0(floodgatePlayer, skinData, false), 200L);
            }
            return;
        }
        GameProfile profile = (GameProfile)ReflectionUtils.castedInvoke(player, ClassNames.GET_PROFILE_METHOD, new Object[0]);
        if (profile == null) {
            throw new IllegalStateException("The GameProfile cannot be null! " + player.getName());
        }
        PropertyMap properties = profile.getProperties();
        SkinApplyEvent.SkinData currentSkin = this.versionSpecificMethods.currentSkin(properties);
        SkinApplyEventImpl event = new SkinApplyEventImpl(floodgatePlayer, currentSkin, skinData);
        event.setCancelled(floodgatePlayer.isLinked());
        this.eventBus.fire(event);
        if (event.isCancelled()) {
            return;
        }
        this.replaceSkin(properties, event.newSkin());
        this.versionSpecificMethods.maybeSchedule(() -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p.equals(player) || !p.canSee(player)) continue;
                this.versionSpecificMethods.hideAndShowPlayer(p, player);
            }
        });
    }

    private void replaceSkin(PropertyMap properties, SkinApplyEvent.SkinData skinData) {
        properties.removeAll((Object)"textures");
        Property property = new Property("textures", skinData.value(), skinData.signature());
        properties.put((Object)"textures", (Object)property);
    }
}

