/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.addon.debug;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.atomic.AtomicInteger;
import org.geysermc.floodgate.api.logger.FloodgateLogger;

@ChannelHandler.Sharable
public final class ChannelInDebugHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final String direction;
    private final FloodgateLogger logger;
    private final AtomicInteger packetCount;

    public ChannelInDebugHandler(String implementationType, boolean toServer, AtomicInteger packetCount, FloodgateLogger logger) {
        this.direction = (toServer ? "Server -> " : "Player -> ") + implementationType;
        this.logger = logger;
        this.packetCount = packetCount;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        try {
            int index = msg.readerIndex();
            if (this.packetCount.getAndIncrement() < 25) {
                this.logger.info("{} {}:\n{}", this.direction, this.packetCount.get(), ByteBufUtil.prettyHexDump((ByteBuf)msg));
            }
            msg.readerIndex(index);
            ctx.fireChannelRead((Object)msg.retain());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

