/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.event.bus.impl;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.event.PostOrder;
import org.geysermc.event.bus.EventBus;
import org.geysermc.event.bus.impl.BaseBusImpl;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.event.subscribe.Subscriber;

public abstract class EventBusImpl<E, S extends Subscriber<? extends E>>
extends BaseBusImpl<E, S>
implements EventBus<E, S> {
    protected abstract <H, T extends E, B extends Subscriber<T>> B makeSubscription(@NonNull Class<T> var1, @NonNull Subscribe var2, @NonNull H var3, @NonNull BiConsumer<H, T> var4);

    protected abstract <T extends E, B extends Subscriber<T>> B makeSubscription(@NonNull Class<T> var1, @NonNull Consumer<T> var2, @NonNull PostOrder var3);

    @Override
    public void register(@NonNull Object listener) {
        this.findSubscriptions(listener, (eventType, subscribe, handler) -> {
            Object subscriber = this.makeSubscription((Class)eventType, (Subscribe)subscribe, (Object)listener, (BiConsumer)handler);
            this.register(eventType, subscriber);
        });
    }

    @Override
    public <T extends E, U extends Subscriber<T>> @NonNull U subscribe(@NonNull Class<T> eventClass, @NonNull Consumer<T> consumer) {
        return this.subscribe(eventClass, consumer, PostOrder.NORMAL);
    }

    @Override
    public <T extends E, U extends Subscriber<T>> @NonNull U subscribe(@NonNull Class<T> eventClass, @NonNull Consumer<T> consumer, @NonNull PostOrder postOrder) {
        Object subscription = this.makeSubscription(eventClass, consumer, postOrder);
        this.register(eventClass, subscription);
        return (U)subscription;
    }

    @Override
    public void unregisterAll() {
        super.unsubscribeAll();
    }

    @Override
    public <T extends E> @NonNull Set<? extends Subscriber<T>> subscribers(@NonNull Class<T> eventClass) {
        return Collections.unmodifiableSet(this.eventSubscribers(eventClass));
    }
}

