/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.signs.SignException;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.ess3.api.IEssentials;
import net.ess3.api.MaxMoneyException;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;

@Deprecated
public class SignProtection
extends EssentialsSign {
    private final transient Set<Material> protectedBlocks = EnumUtil.getAllMatching(Material.class, "CHEST", "FURNACE", "BURNING_FURNACE", "DISPENSER");

    public SignProtection() {
        super("Protection");
    }

    @Override
    protected boolean onSignCreate(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException, ChargeException {
        SignProtectionState state;
        sign.setLine(3, "\u00a74" + username);
        if (this.hasAdjacentBlock(sign.getBlock(), new Block[0]) && ((state = this.isBlockProtected(sign.getBlock(), player, username, true)) == SignProtectionState.NOSIGN || state == SignProtectionState.OWNER || player.isAuthorized("essentials.signs.protection.override"))) {
            sign.setLine(3, "\u00a71" + username);
            return true;
        }
        player.sendMessage(I18n.tl("signProtectInvalidLocation", new Object[0]));
        return false;
    }

    @Override
    protected boolean onSignBreak(EssentialsSign.ISign sign, User player, String username, IEssentials ess) throws SignException {
        SignProtectionState state = this.checkProtectionSign(sign, player, username);
        return state == SignProtectionState.OWNER;
    }

    public boolean hasAdjacentBlock(Block block, Block ... ignoredBlocks) {
        Block[] faces;
        for (Block b : faces = this.getAdjacentBlocks(block)) {
            for (Block ignoredBlock : ignoredBlocks) {
                if (!b.getLocation().equals((Object)ignoredBlock.getLocation())) continue;
            }
            if (!this.protectedBlocks.contains(b.getType())) continue;
            return true;
        }
        return false;
    }

    private void checkIfSignsAreBroken(Block block, User player, String username, IEssentials ess) throws MaxMoneyException {
        Map<Location, SignProtectionState> signs = this.getConnectedSigns(block, player, username, false);
        for (Map.Entry<Location, SignProtectionState> entry : signs.entrySet()) {
            if (entry.getValue() == SignProtectionState.NOSIGN) continue;
            Block sign = entry.getKey().getBlock();
            if (this.hasAdjacentBlock(sign, block)) continue;
            block.setType(Material.AIR);
            Trade trade = new Trade(new ItemStack(sign.getType(), 1), ess);
            trade.pay(player, Trade.OverflowType.DROP);
        }
    }

    private Map<Location, SignProtectionState> getConnectedSigns(Block block, User user, String username, boolean secure) {
        HashMap<Location, SignProtectionState> signs = new HashMap<Location, SignProtectionState>();
        this.getConnectedSigns(block, signs, user, username, secure ? 4 : 2);
        return signs;
    }

    private void getConnectedSigns(Block block, Map<Location, SignProtectionState> signs, User user, String username, int depth) {
        Block[] faces;
        for (Block b : faces = this.getAdjacentBlocks(block)) {
            Location loc = b.getLocation();
            if (signs.containsKey(loc)) continue;
            SignProtectionState check = this.checkProtectionSign(b, user, username);
            signs.put(loc, check);
            if (!this.protectedBlocks.contains(b.getType()) || depth <= 0) continue;
            this.getConnectedSigns(b, signs, user, username, depth - 1);
        }
    }

    private SignProtectionState checkProtectionSign(Block block, User user, String username) {
        EssentialsSign.BlockSign sign;
        if (MaterialUtil.isSign(block.getType()) && (sign = new EssentialsSign.BlockSign(block)).getLine(0).equals(this.getSuccessName())) {
            return this.checkProtectionSign(sign, user, username);
        }
        return SignProtectionState.NOSIGN;
    }

    private SignProtectionState checkProtectionSign(EssentialsSign.ISign sign, User user, String username) {
        if (user == null || username == null) {
            return SignProtectionState.NOT_ALLOWED;
        }
        if (user.isAuthorized("essentials.signs.protection.override")) {
            return SignProtectionState.OWNER;
        }
        if (this.isOwner(user.getEssentials(), user, sign, 3, "\u00a71")) {
            return SignProtectionState.OWNER;
        }
        for (int i = 1; i <= 2; ++i) {
            String line = sign.getLine(i);
            if (line.startsWith("(") && line.endsWith(")") && user.inGroup(line.substring(1, line.length() - 1))) {
                return SignProtectionState.ALLOWED;
            }
            if (!line.equalsIgnoreCase(username)) continue;
            return SignProtectionState.ALLOWED;
        }
        return SignProtectionState.NOT_ALLOWED;
    }

    private Block[] getAdjacentBlocks(Block block) {
        return new Block[]{block.getRelative(BlockFace.NORTH), block.getRelative(BlockFace.SOUTH), block.getRelative(BlockFace.EAST), block.getRelative(BlockFace.WEST), block.getRelative(BlockFace.DOWN), block.getRelative(BlockFace.UP)};
    }

    public SignProtectionState isBlockProtected(Block block, User user, String username, boolean secure) {
        Map<Location, SignProtectionState> signs = this.getConnectedSigns(block, user, username, secure);
        SignProtectionState retstate = SignProtectionState.NOSIGN;
        for (SignProtectionState state : signs.values()) {
            if (state == SignProtectionState.ALLOWED) {
                retstate = state;
                continue;
            }
            if (state != SignProtectionState.NOT_ALLOWED || retstate == SignProtectionState.ALLOWED) continue;
            retstate = state;
        }
        if (!secure || retstate == SignProtectionState.NOSIGN) {
            for (SignProtectionState state : signs.values()) {
                if (state != SignProtectionState.OWNER) continue;
                return state;
            }
        }
        return retstate;
    }

    public boolean isBlockProtected(Block block) {
        Block[] faces;
        for (Block b : faces = this.getAdjacentBlocks(block)) {
            Block[] faceChest;
            Sign sign;
            if (MaterialUtil.isSign(b.getType()) && (sign = (Sign)b.getState()).getLine(0).equalsIgnoreCase("\u00a71[Protection]")) {
                return true;
            }
            if (!this.protectedBlocks.contains(b.getType())) continue;
            for (Block a : faceChest = this.getAdjacentBlocks(b)) {
                Sign sign2;
                if (!MaterialUtil.isSign(a.getType()) || !(sign2 = (Sign)a.getState()).getLine(0).equalsIgnoreCase("\u00a71[Protection]")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Material> getBlocks() {
        return this.protectedBlocks;
    }

    @Override
    public boolean areHeavyEventRequired() {
        return true;
    }

    @Override
    protected boolean onBlockPlace(Block block, User player, String username, IEssentials ess) throws SignException {
        for (Block adjBlock : this.getAdjacentBlocks(block)) {
            SignProtectionState state = this.isBlockProtected(adjBlock, player, username, true);
            if (state != SignProtectionState.ALLOWED && state != SignProtectionState.NOT_ALLOWED || player.isAuthorized("essentials.signs.protection.override")) continue;
            player.sendMessage(I18n.tl("noPlacePermission", block.getType().toString().toLowerCase(Locale.ENGLISH)));
            return false;
        }
        return true;
    }

    @Override
    protected boolean onBlockInteract(Block block, User player, String username, IEssentials ess) throws SignException {
        SignProtectionState state = this.isBlockProtected(block, player, username, false);
        if (state == SignProtectionState.OWNER || state == SignProtectionState.NOSIGN || state == SignProtectionState.ALLOWED) {
            return true;
        }
        if (state == SignProtectionState.NOT_ALLOWED && player.isAuthorized("essentials.signs.protection.override")) {
            return true;
        }
        player.sendMessage(I18n.tl("noAccessPermission", block.getType().toString().toLowerCase(Locale.ENGLISH)));
        return false;
    }

    @Override
    protected boolean onBlockBreak(Block block, User player, String username, IEssentials ess) throws SignException, MaxMoneyException {
        SignProtectionState state = this.isBlockProtected(block, player, username, false);
        if (state == SignProtectionState.OWNER || state == SignProtectionState.NOSIGN) {
            this.checkIfSignsAreBroken(block, player, username, ess);
            return true;
        }
        if ((state == SignProtectionState.ALLOWED || state == SignProtectionState.NOT_ALLOWED) && player.isAuthorized("essentials.signs.protection.override")) {
            this.checkIfSignsAreBroken(block, player, username, ess);
            return true;
        }
        player.sendMessage(I18n.tl("noDestroyPermission", block.getType().toString().toLowerCase(Locale.ENGLISH)));
        return false;
    }

    @Override
    public boolean onBlockBreak(Block block, IEssentials ess) {
        SignProtectionState state = this.isBlockProtected(block, null, null, false);
        return state == SignProtectionState.NOSIGN;
    }

    @Override
    public boolean onBlockExplode(Block block, IEssentials ess) {
        SignProtectionState state = this.isBlockProtected(block, null, null, false);
        return state == SignProtectionState.NOSIGN;
    }

    @Override
    public boolean onBlockBurn(Block block, IEssentials ess) {
        SignProtectionState state = this.isBlockProtected(block, null, null, false);
        return state == SignProtectionState.NOSIGN;
    }

    @Override
    public boolean onBlockIgnite(Block block, IEssentials ess) {
        SignProtectionState state = this.isBlockProtected(block, null, null, false);
        return state == SignProtectionState.NOSIGN;
    }

    @Override
    public boolean onBlockPush(Block block, IEssentials ess) {
        SignProtectionState state = this.isBlockProtected(block, null, null, false);
        return state == SignProtectionState.NOSIGN;
    }

    public static enum SignProtectionState {
        NOT_ALLOWED,
        ALLOWED,
        NOSIGN,
        OWNER;

    }
}

