/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.craftbukkit.SetExpFix;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.NumberUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.Server;
import org.bukkit.Statistic;

public class Commandwhois
extends EssentialsCommand {
    private static final Statistic PLAY_ONE_TICK = EnumUtil.getStatistic("PLAY_ONE_MINUTE", "PLAY_ONE_TICK");

    public Commandwhois() {
        super("whois");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        String location;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.getPlayer(server, sender, args, 0);
        sender.sendMessage(I18n.tl("whoisTop", user.getName()));
        user.setDisplayNick();
        sender.sendMessage(I18n.tl("whoisNick", user.getDisplayName()));
        sender.sendMessage(I18n.tl("whoisUuid", user.getBase().getUniqueId().toString()));
        sender.sendMessage(I18n.tl("whoisHealth", user.getBase().getHealth()));
        sender.sendMessage(I18n.tl("whoisHunger", user.getBase().getFoodLevel(), Float.valueOf(user.getBase().getSaturation())));
        sender.sendMessage(I18n.tl("whoisExp", SetExpFix.getTotalExperience(user.getBase()), user.getBase().getLevel()));
        sender.sendMessage(I18n.tl("whoisLocation", user.getLocation().getWorld().getName(), user.getLocation().getBlockX(), user.getLocation().getBlockY(), user.getLocation().getBlockZ()));
        long playtimeMs = System.currentTimeMillis() - (long)user.getBase().getStatistic(PLAY_ONE_TICK) * 50L;
        sender.sendMessage(I18n.tl("whoisPlaytime", DateUtil.formatDateDiff(playtimeMs)));
        if (!this.ess.getSettings().isEcoDisabled()) {
            sender.sendMessage(I18n.tl("whoisMoney", NumberUtil.displayCurrency(user.getMoney(), this.ess)));
        }
        if (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.whois.ip")) {
            sender.sendMessage(I18n.tl("whoisIPAddress", user.getBase().getAddress().getAddress().toString()));
        }
        if ((location = user.getGeoLocation()) != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendMessage(I18n.tl("whoisGeoLocation", location));
        }
        sender.sendMessage(I18n.tl("whoisGamemode", I18n.tl(user.getBase().getGameMode().toString().toLowerCase(Locale.ENGLISH), new Object[0])));
        sender.sendMessage(I18n.tl("whoisGod", user.isGodModeEnabled() ? I18n.tl("true", new Object[0]) : I18n.tl("false", new Object[0])));
        sender.sendMessage(I18n.tl("whoisOp", user.getBase().isOp() ? I18n.tl("true", new Object[0]) : I18n.tl("false", new Object[0])));
        sender.sendMessage(I18n.tl("whoisFly", user.getBase().getAllowFlight() ? I18n.tl("true", new Object[0]) : I18n.tl("false", new Object[0]), user.getBase().isFlying() ? I18n.tl("flying", new Object[0]) : I18n.tl("notFlying", new Object[0])));
        sender.sendMessage(I18n.tl("whoisSpeed", Float.valueOf(user.getBase().isFlying() ? user.getBase().getFlySpeed() : user.getBase().getWalkSpeed())));
        if (user.isAfk()) {
            sender.sendMessage(I18n.tl("whoisAFKSince", I18n.tl("true", new Object[0]), DateUtil.formatDateDiff(user.getAfkSince())));
        } else {
            sender.sendMessage(I18n.tl("whoisAFK", I18n.tl("false", new Object[0])));
        }
        Object[] objectArray = new Object[1];
        objectArray[0] = user.isJailed() ? (user.getJailTimeout() > 0L ? user.getFormattedJailTime() : I18n.tl("true", new Object[0])) : I18n.tl("false", new Object[0]);
        sender.sendMessage(I18n.tl("whoisJail", objectArray));
        long muteTimeout = user.getMuteTimeout();
        if (!user.hasMuteReason()) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = user.isMuted() ? (muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : I18n.tl("true", new Object[0])) : I18n.tl("false", new Object[0]);
            sender.sendMessage(I18n.tl("whoisMuted", objectArray2));
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = user.isMuted() ? (muteTimeout > 0L ? DateUtil.formatDateDiff(muteTimeout) : I18n.tl("true", new Object[0])) : I18n.tl("false", new Object[0]);
            objectArray3[1] = user.getMuteReason();
            sender.sendMessage(I18n.tl("whoisMutedReason", objectArray3));
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

