/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Commandskull
extends EssentialsCommand {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[A-Za-z0-9_]+$");
    private static final Material SKULL_ITEM = EnumUtil.getMaterial("PLAYER_HEAD", "SKULL_ITEM");

    public Commandskull() {
        super("skull");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        SkullMeta metaSkull;
        String owner;
        if (args.length > 0 && user.isAuthorized("essentials.skull.others")) {
            if (!NAME_PATTERN.matcher(args[0]).matches()) {
                throw new IllegalArgumentException(I18n.tl("alphaNames", new Object[0]));
            }
            owner = args[0];
        } else {
            owner = user.getName();
        }
        ItemStack itemSkull = user.getItemInHand();
        boolean spawn = false;
        if (itemSkull != null && MaterialUtil.isPlayerHead(itemSkull)) {
            metaSkull = (SkullMeta)itemSkull.getItemMeta();
        } else if (user.isAuthorized("essentials.skull.spawn")) {
            itemSkull = new ItemStack(SKULL_ITEM, 1, 3);
            metaSkull = (SkullMeta)itemSkull.getItemMeta();
            spawn = true;
        } else {
            throw new Exception(I18n.tl("invalidSkull", new Object[0]));
        }
        if (metaSkull.hasOwner() && !user.isAuthorized("essentials.skull.modify")) {
            throw new Exception(I18n.tl("noPermissionSkull", new Object[0]));
        }
        this.editSkull(user, itemSkull, metaSkull, owner, spawn);
    }

    private void editSkull(User user, ItemStack stack, SkullMeta skullMeta, String owner, boolean spawn) {
        this.ess.runTaskAsynchronously(() -> {
            skullMeta.setDisplayName("\u00a7fSkull of " + owner);
            skullMeta.setOwner(owner);
            this.ess.scheduleSyncDelayedTask(() -> {
                stack.setItemMeta((ItemMeta)skullMeta);
                if (spawn) {
                    Inventories.addItem(user.getBase(), stack);
                    user.sendMessage(I18n.tl("givenSkull", owner));
                    return;
                }
                user.sendMessage(I18n.tl("skullChanged", owner));
            });
        });
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            if (user.isAuthorized("essentials.skull.others")) {
                return this.getPlayers(server, user);
            }
            return Lists.newArrayList((Object[])new String[]{user.getName()});
        }
        return Collections.emptyList();
    }
}

