/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerExemptException;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class Commandkill
extends EssentialsLoopCommand {
    public Commandkill() {
        super("kill");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        this.loopOnlinePlayers(server, sender, true, true, args[0], null);
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User user, String[] args) throws PlayerExemptException {
        Player matchPlayer = user.getBase();
        if (sender.isPlayer() && user.isAuthorized("essentials.kill.exempt") && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.kill.force")) {
            throw new PlayerExemptException(I18n.tl("killExempt", matchPlayer.getDisplayName()));
        }
        EntityDamageEvent ede = new EntityDamageEvent((Entity)matchPlayer, sender.isPlayer() && sender.getPlayer().getName().equals(matchPlayer.getName()) ? EntityDamageEvent.DamageCause.SUICIDE : EntityDamageEvent.DamageCause.CUSTOM, 3.4028234663852886E38);
        server.getPluginManager().callEvent((Event)ede);
        if (ede.isCancelled() && sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.kill.force")) {
            return;
        }
        ede.getEntity().setLastDamageCause(ede);
        matchPlayer.setHealth(0.0);
        sender.sendMessage(I18n.tl("kill", matchPlayer.getDisplayName()));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

