/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.earth2me.essentials.utils.TriState;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Commanditemname
extends EssentialsCommand {
    public static final String PERM_PREFIX = "essentials.itemname.prevent-type.";

    public Commanditemname() {
        super("itemname");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        ItemStack item = Inventories.getItemInHand(user.getBase());
        if (item == null || MaterialUtil.isAir(item.getType())) {
            user.sendMessage(I18n.tl("itemnameInvalidItem", new Object[0]));
            return;
        }
        TriState wildcard = user.isAuthorizedExact("essentials.itemname.prevent-type.*");
        TriState material = user.isAuthorizedExact(PERM_PREFIX + item.getType().name().toLowerCase());
        if (wildcard == TriState.TRUE && material != TriState.FALSE || wildcard != TriState.TRUE && material == TriState.TRUE) {
            user.sendMessage(I18n.tl("itemnameInvalidItem", new Object[0]));
            return;
        }
        String name = FormatUtil.formatString(user, "essentials.itemname", Commanditemname.getFinalArg(args, 0)).trim();
        if (name.isEmpty()) {
            name = null;
        }
        ItemMeta im = item.getItemMeta();
        im.setDisplayName(name);
        item.setItemMeta(im);
        user.sendMessage(name == null ? I18n.tl("itemnameClear", new Object[0]) : I18n.tl("itemnameSuccess", name));
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        ItemStack item;
        if (args.length == 1 && (item = Inventories.getItemInHand(user.getBase())) != null && !MaterialUtil.isAir(item.getType()) && item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return Lists.newArrayList((Object[])new String[]{FormatUtil.unformatString(user, "essentials.itemname", item.getItemMeta().getDisplayName())});
        }
        return Collections.emptyList();
    }
}

