/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.PlayerInventory;

public class Commandinvsee
extends EssentialsCommand {
    public Commandinvsee() {
        super("invsee");
    }

    @Override
    protected void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        PlayerInventory inv;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User invUser = this.getPlayer(server, user, args, 0);
        if (user == invUser) {
            user.sendMessage(I18n.tl("invseeNoSelf", new Object[0]));
            throw new NoChargeException();
        }
        if (args.length > 1 && user.isAuthorized("essentials.invsee.equip")) {
            inv = server.createInventory((InventoryHolder)invUser.getBase(), 9, "Equipped");
            inv.setContents(invUser.getBase().getInventory().getArmorContents());
            if (VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_9_4_R01)) {
                inv.setItem(4, invUser.getBase().getInventory().getItemInOffHand());
            }
        } else {
            inv = invUser.getBase().getInventory();
        }
        user.getBase().closeInventory();
        user.getBase().openInventory((Inventory)inv);
        user.setInvSee(true);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1) {
            List<String> suggestions = this.getPlayers(server, user);
            suggestions.remove(user.getName());
            return suggestions;
        }
        return Collections.emptyList();
    }
}

