/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.ISettings;
import com.earth2me.essentials.User;
import com.earth2me.essentials.craftbukkit.Inventories;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;

public class EssentialsEntityListener
implements Listener {
    private static final transient Pattern powertoolPlayer = Pattern.compile("\\{player\\}");
    private final IEssentials ess;

    public EssentialsEntityListener(IEssentials ess) {
        this.ess = ess;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Projectile projectile;
        ProjectileSource shooter;
        Entity eAttack = event.getDamager();
        Entity eDefend = event.getEntity();
        if (eAttack instanceof Player) {
            User attacker = this.ess.getUser((Player)eAttack);
            if (eDefend instanceof Player) {
                this.onPlayerVsPlayerDamage(event, (Player)eDefend, attacker);
            } else if (eDefend instanceof Ageable) {
                ItemStack hand = Inventories.getItemInMainHand(attacker.getBase());
                if (this.ess.getSettings().isMilkBucketEasterEggEnabled() && hand != null && hand.getType() == Material.MILK_BUCKET) {
                    ((Ageable)eDefend).setBaby();
                    hand.setType(Material.BUCKET);
                    Inventories.setItemInMainHand(attacker.getBase(), hand);
                    attacker.getBase().updateInventory();
                    event.setCancelled(true);
                }
            }
            attacker.updateActivityOnInteract(true);
        } else if (eAttack instanceof Projectile && eDefend instanceof Player && (shooter = (projectile = (Projectile)event.getDamager()).getShooter()) instanceof Player) {
            User attacker = this.ess.getUser((Player)shooter);
            this.onPlayerVsPlayerDamage(event, (Player)eDefend, attacker);
            attacker.updateActivityOnInteract(true);
        }
    }

    private void onPlayerVsPlayerDamage(EntityDamageByEntityEvent event, Player defender, User attacker) {
        if (this.ess.getSettings().getLoginAttackDelay() > 0L && System.currentTimeMillis() < attacker.getLastLogin() + this.ess.getSettings().getLoginAttackDelay() && !attacker.isAuthorized("essentials.pvpdelay.exempt")) {
            event.setCancelled(true);
        }
        if (!defender.equals(attacker.getBase()) && (attacker.hasInvulnerabilityAfterTeleport() || this.ess.getUser(defender).hasInvulnerabilityAfterTeleport())) {
            event.setCancelled(true);
        }
        if (attacker.isGodModeEnabled() && !attacker.isAuthorized("essentials.god.pvp")) {
            event.setCancelled(true);
        }
        if (attacker.isHidden() && !attacker.isAuthorized("essentials.vanish.pvp")) {
            event.setCancelled(true);
        }
        if (attacker.arePowerToolsEnabled()) {
            this.onPlayerVsPlayerPowertool(event, defender, attacker);
        }
    }

    private void onPlayerVsPlayerPowertool(EntityDamageByEntityEvent event, Player defender, final User attacker) {
        List<String> commandList = attacker.getPowertool(Inventories.getItemInHand(attacker.getBase()));
        if (commandList != null && !commandList.isEmpty()) {
            for (String tempCommand : commandList) {
                final String command = powertoolPlayer.matcher(tempCommand).replaceAll(defender.getName());
                if (command == null || command.isEmpty() || command.equals(tempCommand)) continue;
                class PowerToolInteractTask
                implements Runnable {
                    PowerToolInteractTask() {
                    }

                    @Override
                    public void run() {
                        attacker.getBase().chat("/" + command);
                        EssentialsEntityListener.this.ess.getLogger().log(Level.INFO, String.format("[PT] %s issued server command: /%s", attacker.getName(), command));
                    }
                }
                this.ess.scheduleSyncDelayedTask(new PowerToolInteractTask());
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player && this.ess.getUser((Player)event.getEntity()).isGodModeEnabled()) {
            Player player = (Player)event.getEntity();
            player.setFireTicks(0);
            player.setRemainingAir(player.getMaximumAir());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityCombust(EntityCombustEvent event) {
        if (event.getEntity() instanceof Player && this.ess.getUser((Player)event.getEntity()).isGodModeEnabled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityCombustByEntity(EntityCombustByEntityEvent event) {
        Arrow combuster;
        if (event.getCombuster() instanceof Arrow && event.getEntity() instanceof Player && (combuster = (Arrow)event.getCombuster()).getShooter() instanceof Player) {
            Player shooter = (Player)combuster.getShooter();
            if (shooter.hasMetadata("NPC")) {
                return;
            }
            User srcCombuster = this.ess.getUser(shooter.getUniqueId());
            if (srcCombuster.isGodModeEnabled() && !srcCombuster.isAuthorized("essentials.god.pvp")) {
                event.setCancelled(true);
            }
            if (srcCombuster.isHidden() && !srcCombuster.isAuthorized("essentials.vanish.pvp")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDeathEvent(PlayerDeathEvent event) {
        Player entity = event.getEntity();
        if (entity.hasMetadata("NPC")) {
            return;
        }
        User user = this.ess.getUser(event.getEntity());
        if (this.ess.getSettings().infoAfterDeath()) {
            Location loc = user.getLocation();
            user.sendMessage(I18n.tl("infoAfterDeath", loc.getWorld().getName(), loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()));
        }
        if (user.isAuthorized("essentials.back.ondeath") && !this.ess.getSettings().isCommandDisabled("back")) {
            user.setLastLocation();
            user.sendMessage(I18n.tl("backAfterDeath", new Object[0]));
        }
        if (!this.ess.getSettings().areDeathMessagesEnabled()) {
            event.setDeathMessage("");
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeathExpEvent(PlayerDeathEvent event) {
        User user = this.ess.getUser(event.getEntity());
        if (user.isAuthorized("essentials.keepxp")) {
            event.setKeepLevel(true);
            event.setDroppedExp(0);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeathInvEvent(PlayerDeathEvent event) {
        User user = this.ess.getUser(event.getEntity());
        if (user.isAuthorized("essentials.keepinv")) {
            event.setKeepInventory(true);
            event.getDrops().clear();
            ISettings.KeepInvPolicy vanish = this.ess.getSettings().getVanishingItemsPolicy();
            ISettings.KeepInvPolicy bind = this.ess.getSettings().getBindingItemsPolicy();
            if (VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_11_2_R01) && (vanish != ISettings.KeepInvPolicy.KEEP || bind != ISettings.KeepInvPolicy.KEEP)) {
                Inventories.removeItems(user.getBase(), stack -> {
                    if (vanish != ISettings.KeepInvPolicy.KEEP && stack.getEnchantments().containsKey(Enchantment.VANISHING_CURSE)) {
                        if (vanish == ISettings.KeepInvPolicy.DROP) {
                            event.getDrops().add(stack.clone());
                        }
                        return true;
                    }
                    if (bind != ISettings.KeepInvPolicy.KEEP && stack.getEnchantments().containsKey(Enchantment.BINDING_CURSE)) {
                        if (bind == ISettings.KeepInvPolicy.DROP) {
                            event.getDrops().add(stack.clone());
                        }
                        return true;
                    }
                    return false;
                }, true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        User user;
        if (event.getEntity() instanceof Player && (user = this.ess.getUser((Player)event.getEntity())).isGodModeEnabled()) {
            if (user.isGodModeEnabledRaw()) {
                user.getBase().setFoodLevel(20);
                user.getBase().setSaturation(10.0f);
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED && event.getEntity() instanceof Player && this.ess.getUser((Player)event.getEntity()).isAfk() && this.ess.getSettings().getFreezeAfkPlayers()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent event) {
        for (LivingEntity entity : event.getAffectedEntities()) {
            if (!(entity instanceof Player) || !this.ess.getUser((Player)entity).isGodModeEnabled()) continue;
            event.setIntensity(entity, 0.0);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityShootBow(EntityShootBowEvent event) {
        User user;
        if (event.getEntity() instanceof Player && (user = this.ess.getUser((Player)event.getEntity())).isAfk()) {
            user.updateActivityOnInteract(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        User user;
        if (event.getTarget() instanceof Player && (user = this.ess.getUser((Player)event.getTarget())).isVanished()) {
            event.setCancelled(true);
        }
    }
}

