/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util.service;

import codes.wasabi.xclaim.util.service.ServiceInitException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceFactory<T> {
    private final Class<? extends T>[] serviceClasses;

    @SafeVarargs
    public ServiceFactory(Class<? extends T> ... serviceClasses) {
        for (Class<T> clazz : serviceClasses) {
            int mod = clazz.getModifiers();
            if (!Modifier.isInterface(mod) && !Modifier.isAbstract(mod)) continue;
            throw new IllegalArgumentException(clazz.getName() + " is abstract");
        }
        this.serviceClasses = Arrays.copyOf(serviceClasses, serviceClasses.length);
    }

    @NotNull
    public T create() throws ServiceInitException {
        ServiceInitException e = null;
        for (Class<T> clazz : this.serviceClasses) {
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InvocationTargetException e1) {
                Throwable cause = e1.getCause();
                if (cause instanceof ServiceInitException) {
                    e = (ServiceInitException)cause;
                    continue;
                }
                throw new ServiceInitException("Unexpected error in initializer for class \"" + clazz.getName() + "\"", cause);
            }
            catch (LinkageError | ReflectiveOperationException | SecurityException e1) {
                throw new ServiceInitException("Unexpected error in initializer for class \"" + clazz.getName() + "\"", e1);
            }
        }
        if (e != null) {
            throw e;
        }
        throw new ServiceInitException("No services set to be loaded");
    }

    @Nullable
    public T createElseNull(boolean log) {
        try {
            return this.create();
        }
        catch (ServiceInitException e) {
            if (log) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Nullable
    public T createElseNull() {
        return this.createElseNull(false);
    }
}

