/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util.metric;

import codes.wasabi.xclaim.util.metric.IMetric;
import codes.wasabi.xclaim.util.metric.Metric;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetricSet
extends AbstractSet<IMetric> {
    private static final MetricSet ALL = MetricSet.of(Metric.values());
    protected final int root;
    protected final IMetric[] universe;
    protected final int len;

    @NotNull
    public static MetricSet all() {
        return ALL;
    }

    @NotNull
    public static MetricSet of(@NotNull Iterable<IMetric> iter) throws IllegalArgumentException {
        int max;
        int len = 1;
        Iterator<IMetric> ia = iter.iterator();
        if (!ia.hasNext()) {
            throw new IllegalArgumentException("MetricSet cannot be empty");
        }
        int min = max = ia.next().magnitude();
        while (ia.hasNext()) {
            IMetric tmp = ia.next();
            if (tmp.magnitude() < min) {
                min = tmp.magnitude();
            } else if (tmp.magnitude() > max) {
                max = tmp.magnitude();
            }
            ++len;
        }
        return new MetricSet(iter, min, max, len);
    }

    @NotNull
    public static MetricSet of(IMetric ... metrics) throws IllegalArgumentException {
        return MetricSet.of(Arrays.asList(metrics));
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    MetricSet(Iterable<IMetric> iter, int min, int max, int len) throws IllegalArgumentException {
        int universeLen = max - min + 1;
        IMetric[] universe = new IMetric[universeLen];
        for (IMetric m : iter) {
            int dest = m.magnitude() - min;
            if (dest < 0 || dest >= universeLen) {
                throw new ConcurrentModificationException();
            }
            if (universe[dest] != null) {
                throw new IllegalArgumentException("Metrics passed to MetricSet have multiple Metrics with the same magnitude (" + m.magnitude() + ")");
            }
            universe[dest] = m;
        }
        this.root = min;
        this.universe = universe;
        this.len = len;
    }

    @NotNull
    public IMetric getByMagnitude(int magnitude) {
        if ((magnitude -= this.root) <= 0) {
            return this.universe[0];
        }
        for (int i = Math.min(magnitude, this.universe.length - 1); i >= 0; --i) {
            IMetric ret = this.universe[i];
            if (ret == null) continue;
            return ret;
        }
        throw new AssertionError((Object)"Malformed universe");
    }

    @Nullable
    public IMetric getByMagnitudeExact(int magnitude) {
        if ((magnitude -= this.root) < 0) {
            return null;
        }
        if (magnitude >= this.universe.length) {
            return null;
        }
        return this.universe[magnitude];
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof IMetric)) {
            return false;
        }
        return this.getByMagnitudeExact(((IMetric)o).magnitude()) != null;
    }

    @Override
    @NotNull
    public Iterator<IMetric> iterator() {
        return new Iter(this);
    }

    public static final class Builder {
        private List<IMetric> list = new LinkedList<IMetric>();
        private boolean linked = true;
        private int min = 0;
        private int max = 0;

        private void makeArray(int capacityHint) {
            if (this.linked) {
                ArrayList<IMetric> cpy = new ArrayList<IMetric>(this.list.size() + capacityHint);
                cpy.addAll(this.list);
                this.list = cpy;
                this.linked = false;
            }
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder add(@NotNull IMetric metric) {
            int mag = metric.magnitude();
            if (this.list.isEmpty()) {
                this.min = this.max = mag;
            } else if (mag < this.min) {
                this.min = mag;
            } else if (mag > this.max) {
                this.max = mag;
            }
            this.list.add(metric);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder add(@NotNull Iterable<IMetric> metrics) {
            this.makeArray(0);
            for (IMetric metric : metrics) {
                this.add(metric);
            }
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder add(@NotNull Collection<IMetric> metrics) {
            this.makeArray(metrics.size());
            for (IMetric metric : metrics) {
                this.add(metric);
            }
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder add(IMetric ... metrics) {
            this.makeArray(metrics.length);
            for (IMetric metric : metrics) {
                this.add(metric);
            }
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder upTo(@NotNull Metric metric) {
            Metric[] values = Metric.values();
            this.makeArray(values.length);
            for (Metric value : values) {
                this.add((IMetric)value);
                if (value == metric) break;
            }
            return this;
        }

        @Contract(value=" -> new")
        @NotNull
        public MetricSet build() throws IllegalStateException {
            int len = this.list.size();
            if (len == 0) {
                throw new IllegalStateException("MetricSet cannot be empty");
            }
            return new MetricSet(this.list, this.min, this.max, len);
        }
    }

    private static final class Iter
    implements Iterator<IMetric> {
        private final MetricSet parent;
        private int head = 0;

        Iter(MetricSet parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.head < this.parent.universe.length;
        }

        @Override
        @NotNull
        public IMetric next() throws NoSuchElementException {
            while (this.head < this.parent.universe.length) {
                IMetric ret;
                if ((ret = this.parent.universe[this.head++]) == null) continue;
                return ret;
            }
            throw new NoSuchElementException();
        }
    }
}

