/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util.metric;

import codes.wasabi.xclaim.util.metric.IMetric;
import codes.wasabi.xclaim.util.metric.MetricSet;
import java.text.DecimalFormat;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetricFormatter {
    private static final DecimalFormat[] DECIMAL_FORMATS = new DecimalFormat[]{new DecimalFormat("0.##"), new DecimalFormat("0.#")};
    private final MetricSet metrics;

    @NotNull
    public static MetricFormatter instance() {
        return new MetricFormatter(MetricSet.all());
    }

    public MetricFormatter(@NotNull MetricSet metrics) {
        this.metrics = metrics;
    }

    @Contract(value="_, null, true -> fail; _, !null, _ -> _; _, null, false -> _")
    @NotNull
    private String format00(double value, CharSequence postfix, boolean hasPostfix) {
        int magnitude = (int)Math.log10(value);
        IMetric metric = this.metrics.getByMagnitude(magnitude);
        int overshot = magnitude - metric.magnitude();
        boolean spaced = false;
        String ret = overshot >= 0 && overshot < 2 ? DECIMAL_FORMATS[overshot].format(value) : Long.toString(Math.round(value /= Math.pow(10.0, metric.magnitude())));
        if (metric.hasPrefix()) {
            spaced = true;
            ret = ret + " " + metric.prefix();
        }
        if (hasPostfix) {
            if (!spaced) {
                ret = ret + " ";
            }
            ret = ret + postfix;
        }
        return ret;
    }

    @Contract(value="_, null, true -> fail; _, !null, _ -> _; _, null, false -> _")
    @NotNull
    private String format0(double value, CharSequence postfix, boolean hasPostfix) {
        return value < 0.0 ? "-" + this.format00(Math.abs(value), postfix, hasPostfix) : this.format00(value, postfix, hasPostfix);
    }

    @NotNull
    public String format(double value, @Nullable CharSequence postfix) {
        return this.format0(value, postfix, postfix != null);
    }

    @NotNull
    public String format(double value) {
        return this.format0(value, null, false);
    }
}

