/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util.io;

import codes.wasabi.xclaim.util.io.XmlNode;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlReader
extends FilterReader {
    protected State state = State.READ_TXT;
    protected final Deque<String> stack = new LinkedList<String>();
    private final StringBuilder buf = new StringBuilder();
    private int counter = 0;
    private int peeked = -1;
    private int commentDashes = 0;

    public XmlReader(@NotNull Reader in) {
        super(in);
    }

    protected void setState(@NotNull State state) {
        this.state = state;
        this.buf.setLength(0);
    }

    @NotNull
    public XmlNode readDocument() throws IOException {
        XmlNode document = this.readNodeAssert();
        if (this.readSymbol() != null) {
            this.throwPositioned("Expected end of document");
        }
        return document;
    }

    @NotNull
    public XmlNode readNodeAssert() throws IOException {
        XmlNode ret = this.readNode();
        if (ret == null) {
            this.throwEOF();
        }
        return ret;
    }

    @Nullable
    public XmlNode readNode() throws IOException {
        Symbol symbol = this.readSymbol();
        if (symbol == null || symbol.type() != Symbol.Type.TAG_OPENING) {
            this.throwPositioned("Expected opening tag");
        }
        return this.readNode0(symbol.tag());
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private XmlNode readNode0(@NotNull String tagName) throws IOException {
        Symbol symbol;
        HashMap<String, String> attrs = new HashMap<String, String>();
        LinkedList<XmlNode> children = new LinkedList<XmlNode>();
        while ((symbol = this.readSymbol()) != null) {
            switch (symbol.type().ordinal()) {
                case 0: {
                    children.add(this.readNode0(symbol.tag()));
                    break;
                }
                case 1: {
                    return new XmlNode(tagName, attrs, children);
                }
                case 2: {
                    AttributeSymbol attr = (AttributeSymbol)symbol;
                    if (attrs.containsKey(attr.key)) {
                        this.throwPositioned("Tag <" + tagName + "> has duplicate attribute \"" + attr.key + "\"");
                    }
                    attrs.put(attr.key, attr.value);
                }
            }
        }
        return new XmlNode(tagName, attrs, children);
    }

    @Nullable
    public Symbol readSymbol() throws IOException {
        Symbol symbol = null;
        do {
            int read;
            if (this.peeked != -1) {
                read = this.peeked;
                this.peeked = -1;
            } else {
                read = this.in.read();
                if (read == -1) break;
            }
            symbol = this.readSymbolInternal((char)read);
            ++this.counter;
        } while (symbol == null);
        return symbol;
    }

    @Nullable
    protected Symbol readSymbolInternal(char c) throws IOException {
        if (this.state == State.READ_COMMENT) {
            if (this.commentDashes >= 2) {
                if (c == '>') {
                    this.state = State.READ_TXT;
                } else if (c != '-') {
                    this.commentDashes = 0;
                }
            } else {
                this.commentDashes = c == '-' ? ++this.commentDashes : 0;
            }
            return null;
        }
        if (c == '<') {
            if (this.state == State.READ_TXT) {
                TextSymbol ret = this.buf.length() == 0 ? null : Symbol.text(this.buf.toString());
                this.setState(State.READ_TAG);
                return ret;
            }
            this.throwUnexpectedSymbol(c);
        }
        switch (this.state.ordinal()) {
            case 0: {
                return this.readSymbolForText(c);
            }
            case 1: {
                return this.readSymbolForTag(c);
            }
            case 2: {
                return this.readSymbolForAttrs(c);
            }
        }
        return null;
    }

    @Nullable
    protected Symbol readSymbolForText(char c) throws IOException {
        if (Character.isWhitespace(c)) {
            if (this.buf.length() == 0) {
                return null;
            }
        } else if (this.stack.isEmpty()) {
            this.throwPositioned("Text literal at root of document");
        }
        this.buf.append(c);
        return null;
    }

    @Nullable
    protected Symbol readSymbolForTag(char c) throws IOException {
        boolean initEmpty;
        String tagName = null;
        boolean selfClose = false;
        boolean bl = initEmpty = this.buf.length() == 0;
        if (initEmpty && c == '!') {
            this.commentDashes = 0;
            this.state = State.READ_COMMENT;
            return null;
        }
        switch (c) {
            case '/': {
                if (initEmpty) {
                    this.buf.append(c);
                    break;
                }
                char next = this.pop();
                if (next != '>') {
                    this.throwUnexpectedSymbol(next);
                }
                selfClose = true;
            }
            case '>': {
                tagName = this.buf.toString();
                this.setState(State.READ_TXT);
                break;
            }
            default: {
                boolean startAttrs;
                boolean bl2 = startAttrs = c == ' ';
                if (!startAttrs) {
                    this.buf.append(c);
                }
                if (startAttrs || this.peek() == '/') {
                    tagName = this.buf.toString();
                    this.buf.setLength(0);
                }
                if (!startAttrs) break;
                this.state = State.READ_ATTRS;
            }
        }
        if (tagName != null) {
            if (tagName.isEmpty()) {
                this.throwPositioned("Empty tag");
            }
            boolean closing = selfClose;
            if (tagName.charAt(0) == '/') {
                if (selfClose || tagName.length() < 2) {
                    this.throwPositioned("Closing tag uses self-closing syntax");
                }
                closing = true;
                tagName = tagName.substring(1);
            }
            if (closing) {
                String head = this.stack.pollLast();
                if (!tagName.equals(head)) {
                    this.throwPositioned("Closing tag </" + tagName + "> without matching open tag");
                }
                return Symbol.tagClosing(tagName);
            }
            this.stack.addLast(tagName);
            return Symbol.tagOpening(tagName);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected Symbol readSymbolForAttrs(char c) throws IOException {
        block10: {
            block13: {
                block12: {
                    block11: {
                        switch (c) {
                            case '>': {
                                targetState = State.READ_TXT;
                                break;
                            }
                            case '/': {
                                tagName = this.stack.pollLast();
                                if (!XmlReader.$assertionsDisabled && tagName == null) {
                                    throw new AssertionError();
                                }
                                next = this.pop();
                                if (next != '>') {
                                    this.throwUnexpectedSymbol(next);
                                }
                                this.setState(State.READ_TXT);
                                return Symbol.tagClosing(tagName);
                            }
                            case ' ': {
                                targetState = State.READ_ATTRS;
                                break;
                            }
                            default: {
                                this.buf.append(c);
                                if (this.peek() == '/') {
                                    targetState = State.READ_ATTRS;
                                    break;
                                }
                                return null;
                            }
                        }
                        attr = this.buf.toString();
                        ret = null;
                        if (attr.isEmpty()) break block10;
                        whereEq = attr.indexOf(61);
                        if (whereEq != -1) break block11;
                        ret = Symbol.attribute(attr, "");
                        break block10;
                    }
                    if (whereEq != 0) break block12;
                    this.throwPositioned("Attribute has no key");
                    break block10;
                }
                value = attr.substring(whereEq + 1);
                attr = attr.substring(0, whereEq);
                vl = value.length();
                if (vl < 2) ** GOTO lbl-1000
                q = '\"';
                if (value.charAt(0) == '\"') break block13;
                q = '\'';
                if (value.charAt(0) != '\'') ** GOTO lbl-1000
            }
            if (value.charAt(vl - 1) != q) lbl-1000:
            // 3 sources

            {
                this.throwPositioned("Illegal attribute value (must be delimited by quotes, no leading whitespace)");
            } else {
                ret = Symbol.attribute(attr, value.substring(1, vl - 1));
            }
        }
        this.setState(targetState);
        return ret;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.state == State.READ_TAG || this.state == State.READ_ATTRS) {
                this.throwPositioned("Partial tag");
            }
            if (!this.stack.isEmpty()) {
                this.throwPositioned("Unclosed tag: <" + this.stack.peekLast() + ">");
            }
        }
        finally {
            this.state = State.READ_TXT;
            this.buf.setLength(0);
            this.stack.clear();
            this.counter = 0;
            this.peeked = -1;
            super.close();
        }
    }

    @Contract(value="_ -> fail")
    protected void throwUnexpectedSymbol(char symbol) throws IOException {
        this.throwPositioned("Unexpected symbol: " + symbol);
    }

    @Contract(value="_ -> fail")
    protected void throwPositioned(@NotNull String message) throws IOException {
        throw new IOException(message + " @ char " + this.counter);
    }

    @Contract(value=" -> fail")
    protected void throwEOF() throws EOFException {
        throw new EOFException("Unexpected end of stream @ char " + this.counter);
    }

    protected char peek() throws IOException {
        if (this.peeked != -1) {
            throw new IllegalStateException("peek() called twice in symbol handling");
        }
        int next = this.in.read();
        if (next == -1) {
            this.throwEOF();
        }
        this.peeked = next;
        return (char)next;
    }

    protected char pop() throws IOException {
        int next = this.in.read();
        if (next == -1) {
            this.throwEOF();
        }
        ++this.counter;
        return (char)next;
    }

    protected static enum State {
        READ_TXT,
        READ_TAG,
        READ_ATTRS,
        READ_COMMENT;

    }

    public static interface Symbol {
        @NotNull
        public static TagSymbol tagOpening(@NotNull String tag) {
            return new TagSymbol.Opening(tag);
        }

        @NotNull
        public static TagSymbol tagClosing(@NotNull String tag) {
            return new TagSymbol.Closing(tag);
        }

        @NotNull
        public static AttributeSymbol attribute(@NotNull String key, @Nullable String value) {
            return new AttributeSymbol(key, value);
        }

        @NotNull
        public static TextSymbol text(@Nullable String value) {
            return new TextSymbol(value);
        }

        @NotNull
        public Type type();

        @NotNull
        default public String tag() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        public static enum Type {
            TAG_OPENING,
            TAG_CLOSING,
            ATTRIBUTE,
            TEXT;

        }
    }

    public static final class AttributeSymbol
    implements Symbol {
        private final String key;
        private final String value;

        public AttributeSymbol(@NotNull String key, @Nullable String value) {
            this.key = key;
            this.value = value == null ? "" : value;
        }

        @Override
        @NotNull
        public Symbol.Type type() {
            return Symbol.Type.ATTRIBUTE;
        }

        @NotNull
        public String key() {
            return this.key;
        }

        @NotNull
        public String value() {
            return this.value;
        }

        public String toString() {
            return "AttributeSymbol[key=" + this.key + ", value=" + this.value + "]";
        }
    }

    public static final class TextSymbol
    implements Symbol {
        private final String value;

        public TextSymbol(@Nullable String value) {
            this.value = value == null ? "" : value;
        }

        @Override
        @NotNull
        public Symbol.Type type() {
            return Symbol.Type.TEXT;
        }

        @NotNull
        public String value() {
            return this.value;
        }

        public String toString() {
            return "TextSymbol[value=" + this.value + "]";
        }
    }

    public static interface TagSymbol
    extends Symbol {
        @Override
        @NotNull
        public String tag();

        public static final class Closing
        extends Abstract {
            public Closing(@NotNull String tag) {
                super(tag, true);
            }

            public String toString() {
                return "TagSymbol.Closing[tag=" + this.tag() + "]";
            }
        }

        public static final class Opening
        extends Abstract {
            public Opening(@NotNull String tag) {
                super(tag, false);
            }

            public String toString() {
                return "TagSymbol.Opening[tag=" + this.tag() + "]";
            }
        }

        public static abstract class Abstract
        implements TagSymbol {
            private final Symbol.Type type;
            private final String tag;

            public Abstract(@NotNull String tag, boolean closing) {
                this.tag = tag;
                this.type = closing ? Symbol.Type.TAG_CLOSING : Symbol.Type.TAG_OPENING;
            }

            @Override
            @NotNull
            public Symbol.Type type() {
                return this.type;
            }

            @Override
            @NotNull
            public String tag() {
                return this.tag;
            }
        }
    }
}

