/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util;

import java.awt.Color;
import java.util.Random;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class ColorUtil {
    private static final int[][] combinations;

    @NotNull
    public static Color uuidToColor(@NotNull UUID uuid) {
        long mostSig = uuid.getMostSignificantBits();
        long leastSig = uuid.getLeastSignificantBits();
        short[] shorts = new short[]{(short)(mostSig >> 48 & 0xFFFFL), (short)(mostSig >> 32 & 0xFFFFL), (short)(mostSig >> 16 & 0xFFFFL), (short)(mostSig & 0xFFFFL), (short)(leastSig >> 48 & 0xFFFFL), (short)(leastSig >> 32 & 0xFFFFL), (short)(leastSig >> 16 & 0xFFFFL), (short)(leastSig & 0xFFFFL)};
        Random proto = new Random(leastSig);
        int[] comb = combinations[proto.nextInt(336)];
        short a = shorts[comb[0]];
        short b = shorts[comb[1]];
        short c = shorts[comb[2]];
        long seed = (long)c | (long)b << 16 | (long)a << 32 | (long)c << 48;
        proto = new Random(seed);
        float hue = proto.nextFloat();
        if ((hue *= 0.77f) > 0.18f) {
            hue += 0.23f;
        }
        return new Color(Color.HSBtoRGB(hue, 1.0f, 1.0f));
    }

    static {
        int[][] comb = new int[336][];
        int i = 0;
        for (int a = 0; a < 8; ++a) {
            for (int b = 0; b < 8; ++b) {
                if (b == a) continue;
                for (int c = 0; c < 8; ++c) {
                    if (c == b || c == a) continue;
                    comb[i] = new int[]{a, b, c};
                    ++i;
                }
            }
        }
        combinations = comb;
    }
}

