/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.util;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeUtil {
    private static final double[][] ARMOR_TABLE = new double[][]{{1.0, 3.0, 2.0, 1.0}, {2.0, 5.0, 3.0, 1.0}, {2.0, 5.0, 4.0, 1.0}, {2.0, 6.0, 5.0, 2.0}, {3.0, 8.0, 6.0, 3.0}};

    public static double scaleDamage(double damage, @Nullable ItemStack boots, @Nullable ItemStack leggings, @Nullable ItemStack chestplate, @Nullable ItemStack helmet) {
        damage = AttributeUtil.scaleDamage(damage, boots, EquipmentSlot.FEET, 3);
        damage = AttributeUtil.scaleDamage(damage, leggings, EquipmentSlot.LEGS, 2);
        damage = AttributeUtil.scaleDamage(damage, chestplate, EquipmentSlot.CHEST, 1);
        damage = AttributeUtil.scaleDamage(damage, helmet, EquipmentSlot.HEAD, 0);
        return damage;
    }

    private static double scaleDamage(double damage, @Nullable ItemStack item, @NotNull EquipmentSlot slot, int slotCode) {
        if (item == null) {
            return damage;
        }
        if (item.getAmount() < 1) {
            return damage;
        }
        Material type = item.getType();
        if (!type.isItem()) {
            return damage;
        }
        String armorType = type.name().toUpperCase(Locale.ROOT);
        int temp = armorType.indexOf(95);
        if (temp != -1) {
            armorType = armorType.substring(0, temp);
        }
        double armor = 0.0;
        double toughness = 0.0;
        switch (armorType) {
            case "TURTLE": {
                armor = 2.0;
                break;
            }
            case "LEATHER": {
                armor = ARMOR_TABLE[0][slotCode];
                break;
            }
            case "GOLDEN": {
                armor = ARMOR_TABLE[1][slotCode];
                break;
            }
            case "CHAINMAIL": {
                armor = ARMOR_TABLE[2][slotCode];
                break;
            }
            case "IRON": {
                armor = ARMOR_TABLE[3][slotCode];
                break;
            }
            case "DIAMOND": {
                armor = ARMOR_TABLE[4][slotCode];
                toughness = 2.0;
                break;
            }
            case "NETHERITE": {
                armor = ARMOR_TABLE[4][slotCode];
                toughness = 3.0;
            }
        }
        armor = AttributeUtil.scaleByAttributes(armor, type, slot, Attribute.GENERIC_ARMOR);
        toughness = AttributeUtil.scaleByAttributes(toughness, type, slot, Attribute.GENERIC_ARMOR_TOUGHNESS);
        double modification = armor - 4.0 * damage / (toughness + 8.0);
        modification = Math.min(20.0, Math.max(armor / 5.0, modification));
        modification = 1.0 - modification / 25.0;
        damage *= modification;
        Map enchants = item.getEnchantments();
        Integer protectionLevel = (Integer)enchants.get(Enchantment.PROTECTION_ENVIRONMENTAL);
        if (protectionLevel != null && protectionLevel > 0) {
            damage *= 1.0 - (double)protectionLevel.intValue() * 0.04;
        }
        return damage;
    }

    private static double scaleByAttributes(double value, @NotNull Material type, @NotNull EquipmentSlot slot, @NotNull Attribute attribute) {
        Multimap allModifiers = type.getDefaultAttributeModifiers(slot);
        if (allModifiers.isEmpty()) {
            return value;
        }
        Collection modifier = allModifiers.get((Object)attribute);
        if (modifier.isEmpty()) {
            return value;
        }
        for (AttributeModifier am : modifier) {
            switch (am.getOperation()) {
                case ADD_NUMBER: {
                    value += am.getAmount();
                    break;
                }
                case ADD_SCALAR: {
                    value += am.getAmount() * value;
                    break;
                }
                case MULTIPLY_SCALAR_1: {
                    value *= am.getAmount() + 1.0;
                }
            }
        }
        return value;
    }
}

