/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.protection.impl.worldguard;

import codes.wasabi.xclaim.protection.ProtectionRegion;
import codes.wasabi.xclaim.protection.ProtectionService;
import codes.wasabi.xclaim.protection.impl.worldguard.WorldGuardProtectionRegion;
import codes.wasabi.xclaim.util.service.ServiceInitException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;

public class WorldGuardProtectionService
extends ProtectionService {
    private final WorldGuard worldGuard;
    private final WorldGuardPlugin plugin;

    public WorldGuardProtectionService() throws ServiceInitException {
        Object instance;
        Method m;
        try {
            Class<?> apiClass = Class.forName("com.sk89q.worldguard.WorldGuard");
            m = apiClass.getDeclaredMethod("getInstance", new Class[0]);
            instance = m.invoke(null, new Object[0]);
            this.worldGuard = (WorldGuard)instance;
        }
        catch (LinkageError | ReflectiveOperationException | SecurityException e) {
            throw new ServiceInitException("Failed to load WorldGuard API class", e);
        }
        try {
            Class<?> pluginClass = Class.forName("com.sk89q.worldguard.bukkit.WorldGuardPlugin");
            m = pluginClass.getDeclaredMethod("inst", new Class[0]);
            instance = m.invoke(null, new Object[0]);
            this.plugin = (WorldGuardPlugin)instance;
        }
        catch (LinkageError | ReflectiveOperationException | SecurityException e) {
            throw new ServiceInitException("Failed to load WorldGuard Plugin class", e);
        }
    }

    @Override
    public Collection<ProtectionRegion> getRegionsAt(Chunk chunk) {
        RegionManager manager = this.worldGuard.getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)chunk.getWorld()));
        if (manager == null) {
            return Collections.emptyList();
        }
        ArrayList<BlockVector2> vectors = new ArrayList<BlockVector2>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Block b = chunk.getBlock(x, 0, z);
                vectors.add(WorldGuardProtectionService.createWorldEditBlockVector2(b.getX(), b.getZ()));
            }
        }
        ArrayList<WorldGuardProtectionRegion> ret = new ArrayList<WorldGuardProtectionRegion>();
        for (ProtectedRegion region : manager.getRegions().values()) {
            if (!region.containsAny(vectors)) continue;
            ret.add(new WorldGuardProtectionRegion(region, this.plugin));
        }
        return Collections.unmodifiableList(ret);
    }

    private static BlockVector2 createWorldEditBlockVector2(int x, int z) {
        try {
            Class<?> clazz = Class.forName("com.sk89q.worldedit.math.BlockVector2");
            Method m = clazz.getDeclaredMethod("at", Integer.TYPE, Integer.TYPE);
            Object o = m.invoke(null, x, z);
            return (BlockVector2)o;
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

