/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.platform.spigot_1_8;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.platform.PlatformNamespacedKey;
import codes.wasabi.xclaim.platform.PlatformPersistentDataContainer;
import codes.wasabi.xclaim.platform.PlatformPersistentDataType;
import codes.wasabi.xclaim.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.bukkit.entity.Entity;

public class SpigotPlatformPersistentDataContainer_1_8
implements PlatformPersistentDataContainer {
    private final String identifier;
    private final ReentrantLock lock = new ReentrantLock();

    public SpigotPlatformPersistentDataContainer_1_8(Entity entity) {
        this.identifier = entity.getUniqueId().toString();
    }

    private File getPDCFolder() {
        File target;
        File dataFolder = XClaim.dataFolder;
        if (!dataFolder.exists()) {
            boolean created = false;
            try {
                created = dataFolder.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!created) {
                XClaim.logger.log(Level.WARNING, "Failed to create data folder");
            }
        }
        if (!(target = new File(dataFolder, "pdc")).exists()) {
            boolean created = false;
            try {
                created = target.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!created) {
                XClaim.logger.log(Level.WARNING, "Failed to create PDC folder");
            }
        }
        return target;
    }

    private File getDataFile(String name) {
        File pdcFolder = this.getPDCFolder();
        File target = new File(pdcFolder, name);
        if (!target.exists()) {
            boolean created = false;
            try {
                created = target.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!created) {
                XClaim.logger.log(Level.WARNING, "Failed to create data file pdc/" + name);
            }
        }
        return target;
    }

    private File getDataFile() {
        return this.getDataFile(this.identifier + ".dat");
    }

    private static byte typeToCode(PlatformPersistentDataType platformType) {
        byte type = -1;
        switch (platformType) {
            case BYTE: {
                type = 0;
                break;
            }
            case BYTE_ARRAY: {
                type = 1;
                break;
            }
            case STRING: {
                type = 2;
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(PlatformNamespacedKey key, PlatformPersistentDataType type, Object value) {
        String ks = key.toString();
        byte tc = SpigotPlatformPersistentDataContainer_1_8.typeToCode(type);
        this.lock.lock();
        try {
            File src = this.getDataFile();
            byte[] bytes = new byte[]{};
            try (FileInputStream fis = new FileInputStream(src);){
                bytes = StreamUtil.readAllBytes(fis);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            try (FileOutputStream fos = new FileOutputStream(src, false);){
                DataEntry de = new DataEntry();
                while (de.read(bis)) {
                    if (de.identifier.equals(ks) && de.dataType == tc) continue;
                    de.write(fos);
                }
                if (value != null) {
                    de.identifier = ks;
                    de.dataValue = value;
                    de.dataType = tc;
                    de.write(fos);
                }
                fos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(PlatformNamespacedKey key, PlatformPersistentDataType type) {
        String ks = key.toString();
        byte tc = SpigotPlatformPersistentDataContainer_1_8.typeToCode(type);
        Object ret = null;
        this.lock.lock();
        try {
            File src = this.getDataFile();
            try (FileInputStream fis = new FileInputStream(src);){
                DataEntry de = new DataEntry();
                while (de.read(fis)) {
                    if (!de.identifier.equals(ks) || de.dataType != tc) continue;
                    ret = de.dataValue;
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    @Override
    public boolean has(PlatformNamespacedKey key, PlatformPersistentDataType type) {
        return this.get(key, type) != null;
    }

    private static class DataEntry {
        byte dataType;
        String identifier;
        Object dataValue;

        private DataEntry() {
        }

        boolean read(InputStream is) throws IOException {
            int n = is.read();
            if (n < 0) {
                return false;
            }
            this.dataType = (byte)n;
            byte[] idLengthBytes = StreamUtil.readNBytes(is, 2);
            short idLength = ByteBuffer.wrap(idLengthBytes).getShort();
            this.identifier = new String(StreamUtil.readNBytes(is, idLength), StandardCharsets.UTF_8);
            if (this.dataType == 0) {
                this.dataValue = (byte)is.read();
            } else if (this.dataType == 1 || this.dataType == 2) {
                byte[] dataLengthBytes = StreamUtil.readNBytes(is, 4);
                int dataLength = ByteBuffer.wrap(dataLengthBytes).getInt();
                byte[] data = StreamUtil.readNBytes(is, dataLength);
                this.dataValue = this.dataType == 2 ? new String(data, StandardCharsets.UTF_8) : (Object)data;
            }
            return true;
        }

        void write(OutputStream os) throws IOException {
            os.write(this.dataType);
            byte[] idBytes = this.identifier.getBytes(StandardCharsets.UTF_8);
            byte[] idLengthBytes = ByteBuffer.allocate(2).putShort((short)idBytes.length).array();
            os.write(idLengthBytes);
            os.write(idBytes);
            if (this.dataType == 0) {
                os.write(((Byte)this.dataValue).byteValue());
            } else if (this.dataType == 1 || this.dataType == 2) {
                byte[] data = this.dataType == 2 ? ((String)this.dataValue).getBytes(StandardCharsets.UTF_8) : (byte[])this.dataValue;
                os.write(ByteBuffer.allocate(4).putInt(data.length).array());
                os.write(data);
            }
        }
    }
}

