/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.platform.spigot;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.platform.PlatformChatListener;
import codes.wasabi.xclaim.platform.PlatformScheduler;
import codes.wasabi.xclaim.platform.spigot.SpigotPlatformChatListener;
import codes.wasabi.xclaim.platform.spigot.SpigotPlatformScheduler;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpigotPlatform
extends Platform {
    private SpigotPlatformScheduler scheduler = null;
    private boolean schedulerInit = false;

    @Override
    @Nullable
    public OfflinePlayer getOfflinePlayerIfCached(@NotNull String name) {
        for (OfflinePlayer op : Bukkit.getOfflinePlayers()) {
            String n = op.getName();
            if (n == null || !n.equals(name)) continue;
            return op;
        }
        return null;
    }

    @Override
    public byte @NotNull [] itemStackSerializeBytes(@NotNull ItemStack is) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (BukkitObjectOutputStream oos = new BukkitObjectOutputStream((OutputStream)bos);){
            oos.writeObject((Object)is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    @Override
    @NotNull
    public ItemStack itemStackDeserializeBytes(byte @NotNull [] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ItemStack is = null;
        try (BukkitObjectInputStream ois = new BukkitObjectInputStream((InputStream)bis);){
            Object ob = ois.readObject();
            is = (ItemStack)ob;
        }
        catch (IOException | ClassNotFoundException exception) {
            // empty catch block
        }
        return Objects.requireNonNull(is);
    }

    @Override
    public void metaDisplayName(@NotNull ItemMeta meta, @Nullable Component name) {
        meta.setDisplayName((String)LegacyComponentSerializer.legacySection().serializeOrNull(name));
    }

    @Override
    public void metaLore(@NotNull ItemMeta meta, @Nullable List<Component> lore) {
        if (lore == null) {
            meta.setLore(null);
        } else {
            LegacyComponentSerializer legacy = LegacyComponentSerializer.legacySection();
            ArrayList<String> list = new ArrayList<String>();
            for (Component c : lore) {
                list.add((String)legacy.serializeOrNull(c));
            }
            meta.setLore(list);
        }
    }

    @Override
    public void closeInventory(@NotNull Inventory iv) {
        for (HumanEntity he : new ArrayList(iv.getViewers())) {
            he.closeInventory();
        }
    }

    @Override
    @NotNull
    public Inventory createInventory(@NotNull InventoryHolder holder, int size, @NotNull Component name) {
        return Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)((String)LegacyComponentSerializer.legacySection().serializeOrNull(name)));
    }

    @Contract(value=" -> new")
    protected PlatformChatListener newChatListener() {
        return new SpigotPlatformChatListener();
    }

    @Override
    @NotNull
    public PlatformChatListener onChat() {
        PlatformChatListener listener = this.newChatListener();
        Bukkit.getPluginManager().registerEvents((Listener)listener, (Plugin)XClaim.instance);
        return listener;
    }

    @Override
    @NotNull
    public Component playerDisplayName(@NotNull Player ply) {
        return LegacyComponentSerializer.legacySection().deserialize(ply.getDisplayName());
    }

    @Override
    public void sendActionBar(@NotNull Player ply, @NotNull Component text) {
        SpigotPlatform.getAdventure().player(ply).sendActionBar(text);
    }

    @Override
    public long getLastSeen(@NotNull OfflinePlayer ply) {
        if (ply.isOnline()) {
            return System.currentTimeMillis();
        }
        return ply.getLastPlayed();
    }

    @Override
    @NotNull
    public Location toCenterLocation(@NotNull Location loc) {
        World w = loc.getWorld();
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        return new Location(w, Math.floor(x) + 0.5, Math.floor(y) + 0.5, Math.floor(z) + 0.5, loc.getYaw(), loc.getPitch());
    }

    @Override
    @Nullable
    public Location getInteractionPoint(@NotNull PlayerInteractEvent event) {
        return null;
    }

    @Override
    public boolean supportsArtificalElytraBoost() {
        return false;
    }

    @Override
    public void artificialElytraBoost(Player ply, ItemStack is) {
    }

    @Override
    public PlatformScheduler getScheduler() {
        if (!this.schedulerInit) {
            this.scheduler = new SpigotPlatformScheduler(this, Bukkit.getScheduler());
            this.schedulerInit = true;
        }
        return this.scheduler;
    }

    @Override
    public boolean hasFoliaScheduler() {
        return false;
    }
}

