/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.platform;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformEntityPlaceListener {
    private final List<Consumer<Data>> callbacks = new ArrayList<Consumer<Data>>();

    public final void on(Consumer<Data> cb) {
        this.callbacks.add(cb);
    }

    public final void unregister() {
        this.onUnregister();
        this.callbacks.clear();
    }

    protected final void call(Data data) {
        for (Consumer<Data> con : this.callbacks) {
            con.accept(data);
        }
    }

    protected abstract void onUnregister();

    public static class Data {
        @Nullable
        public Player player;
        public Runnable cancel;
        public boolean isVehicle;
        public Location location;
    }
}

