/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.platform;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.platform.PlatformChatListener;
import codes.wasabi.xclaim.platform.PlatformEntityPlaceListener;
import codes.wasabi.xclaim.platform.PlatformItemPickupListener;
import codes.wasabi.xclaim.platform.PlatformNamespacedKey;
import codes.wasabi.xclaim.platform.PlatformPersistentDataContainer;
import codes.wasabi.xclaim.platform.PlatformScheduler;
import codes.wasabi.xclaim.platform.folia_1_19.FoliaPlatform;
import codes.wasabi.xclaim.platform.paper_1_17.PaperPlatform;
import codes.wasabi.xclaim.platform.spigot_1_10.SpigotPlatform_1_10;
import codes.wasabi.xclaim.platform.spigot_1_11.SpigotPlatform_1_11;
import codes.wasabi.xclaim.platform.spigot_1_12.SpigotPlatform_1_12;
import codes.wasabi.xclaim.platform.spigot_1_12_2.SpigotPlatform_1_12_2;
import codes.wasabi.xclaim.platform.spigot_1_13.SpigotPlatform_1_13;
import codes.wasabi.xclaim.platform.spigot_1_13_2.SpigotPlatform_1_13_2;
import codes.wasabi.xclaim.platform.spigot_1_14.SpigotPlatform_1_14;
import codes.wasabi.xclaim.platform.spigot_1_14_4.SpigotPlatform_1_14_4;
import codes.wasabi.xclaim.platform.spigot_1_15.SpigotPlatform_1_15;
import codes.wasabi.xclaim.platform.spigot_1_16.SpigotPlatform_1_16;
import codes.wasabi.xclaim.platform.spigot_1_17.SpigotPlatform_1_17;
import codes.wasabi.xclaim.platform.spigot_1_19.SpigotPlatform_1_19;
import codes.wasabi.xclaim.platform.spigot_1_8.SpigotPlatform_1_8;
import codes.wasabi.xclaim.platform.spigot_1_9.SpigotPlatform_1_9;
import codes.wasabi.xclaim.shadow.kyori.adventure.platform.bukkit.BukkitAudiences;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.paperlib.PaperLib;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Platform {
    private static boolean initialized = false;
    private static Platform instance;
    private static BukkitAudiences adventure;

    public static void init() {
        if (initialized) {
            return;
        }
        boolean isPaper = PaperLib.isPaper();
        if (!isPaper && !XClaim.mainConfig.noPaperNag().booleanValue()) {
            PaperLib.suggestPaper((Plugin)XClaim.instance);
        }
        instance = PaperLib.isVersion(17) ? (Platform.isFolia() ? new FoliaPlatform() : (isPaper ? new PaperPlatform() : (PaperLib.isVersion(19) ? new SpigotPlatform_1_19() : new SpigotPlatform_1_17()))) : (PaperLib.isVersion(16) ? new SpigotPlatform_1_16() : (PaperLib.isVersion(15) ? new SpigotPlatform_1_15() : (PaperLib.isVersion(14, 4) ? new SpigotPlatform_1_14_4() : (PaperLib.isVersion(14) ? new SpigotPlatform_1_14() : (PaperLib.isVersion(13, 2) ? new SpigotPlatform_1_13_2() : (PaperLib.isVersion(13) ? new SpigotPlatform_1_13() : (PaperLib.isVersion(12, 2) ? new SpigotPlatform_1_12_2() : (PaperLib.isVersion(12) ? new SpigotPlatform_1_12() : (PaperLib.isVersion(11) ? new SpigotPlatform_1_11() : (PaperLib.isVersion(10) ? new SpigotPlatform_1_10() : (PaperLib.isVersion(9) ? new SpigotPlatform_1_9() : new SpigotPlatform_1_8())))))))))));
        adventure = BukkitAudiences.create((Plugin)XClaim.instance);
        initialized = true;
    }

    private static boolean isFolia() {
        boolean folia = false;
        try {
            if (PaperLib.isVersion(20)) {
                Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            } else {
                Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            }
            folia = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return folia;
    }

    public static void cleanup() {
        if (!initialized) {
            return;
        }
        instance = null;
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
        initialized = false;
    }

    public static Platform get() {
        return instance;
    }

    public static BukkitAudiences getAdventure() {
        return adventure;
    }

    @Nullable
    public abstract OfflinePlayer getOfflinePlayerIfCached(@NotNull String var1);

    public abstract byte @NotNull [] itemStackSerializeBytes(@NotNull ItemStack var1);

    @NotNull
    public abstract ItemStack itemStackDeserializeBytes(byte @NotNull [] var1);

    public abstract void metaDisplayName(@NotNull ItemMeta var1, @Nullable Component var2);

    public abstract void metaLore(@NotNull ItemMeta var1, @Nullable List<Component> var2);

    public abstract void closeInventory(@NotNull Inventory var1);

    @NotNull
    public abstract Inventory createInventory(@NotNull InventoryHolder var1, int var2, @NotNull Component var3);

    @NotNull
    public abstract PlatformChatListener onChat();

    @NotNull
    public abstract Component playerDisplayName(@NotNull Player var1);

    public abstract void sendActionBar(@NotNull Player var1, @NotNull Component var2);

    public abstract long getLastSeen(@NotNull OfflinePlayer var1);

    @NotNull
    public abstract Location toCenterLocation(@NotNull Location var1);

    @Nullable
    public abstract Location getInteractionPoint(@NotNull PlayerInteractEvent var1);

    public abstract int getWorldMinHeight(@NotNull World var1);

    public abstract PlatformNamespacedKey createNamespacedKey(@NotNull JavaPlugin var1, @NotNull String var2);

    public abstract Material getSpyglassMaterial();

    public abstract EnumSet<EntityType> getMiscTypes();

    @Nullable
    public abstract ItemStack getPlayerItemInUse(Player var1);

    public abstract boolean supportsArtificalElytraBoost();

    public abstract void artificialElytraBoost(Player var1, ItemStack var2);

    @Nullable
    public abstract ItemStack playerInventoryGetItem(PlayerInventory var1, EquipmentSlot var2);

    public abstract boolean supportsArtificialBookOpen();

    public abstract void artificialBookOpen(Player var1, ItemStack var2);

    public abstract void createExplosion(World var1, Location var2, float var3, boolean var4, boolean var5, Entity var6);

    public abstract PlatformPersistentDataContainer getPersistentDataContainer(Entity var1);

    public abstract Material getGreenToken();

    public abstract Material getRedToken();

    public abstract Material getYellowToken();

    public abstract Material getOrangeToken();

    public abstract Material getLimeToken();

    public abstract boolean hasPlaceListener();

    @Nullable
    public abstract PlatformEntityPlaceListener getPlaceListener();

    @NotNull
    public PlatformEntityPlaceListener getPlaceListenerAssert() throws NullPointerException {
        return Objects.requireNonNull(this.getPlaceListener());
    }

    public abstract String getApiVersion(PluginDescriptionFile var1);

    public abstract boolean worldKeepInventory(World var1);

    public abstract Material getPlayerHeadMaterial();

    public abstract Material getGreenConcreteMaterial();

    public abstract Material getRedConcreteMaterial();

    public abstract Material getSkeletonSkullMaterial();

    public abstract Material getEnchantingTableMaterial();

    public abstract Material getChestMinecartMaterial();

    public abstract Material getCraftingTableMaterial();

    public abstract Material getFireworkRocketMaterial();

    public abstract Material[] getSoilMaterials();

    public abstract boolean hasFireChargeMaterial();

    public abstract Material getFireChargeMaterial();

    @Deprecated
    public abstract void setOwningPlayer(SkullMeta var1, OfflinePlayer var2);

    public abstract void setOwningPlayer(SkullMeta var1, UUID var2, String var3);

    public abstract boolean bukkitTaskCancelled(BukkitTask var1);

    public abstract ItemStack preparePlayerSkull(ItemStack var1);

    public abstract boolean materialIsItem(Material var1);

    public abstract Sound getMagicSound();

    public abstract EquipmentSlot getInteractHand(PlayerInteractEvent var1);

    public abstract Sound getClickSound();

    public abstract Sound getExpSound();

    public abstract Sound getEggSound();

    public abstract Sound getLevelSound();

    public abstract Material getShieldMaterial();

    public abstract boolean playerIsGliding(Player var1);

    public abstract PlatformItemPickupListener getItemPickupListener();

    public abstract PlatformScheduler getScheduler();

    public abstract boolean hasFoliaScheduler();
}

