/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.placeholder;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.placeholder.Placeholder;
import codes.wasabi.xclaim.placeholder.Placeholders;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XClaimPlaceholderExpansion
extends PlaceholderExpansion {
    private final XClaim plugin;
    private final Map<String, Placeholder> withoutArgMap;
    private final Map<String, Placeholder> withArgMap;

    public XClaimPlaceholderExpansion(XClaim plugin) {
        this.plugin = plugin;
        HashMap<String, Placeholder> withoutArgMap = new HashMap<String, Placeholder>();
        HashMap<String, Placeholder> withArgMap = new HashMap<String, Placeholder>();
        for (Placeholder p : Placeholders.values()) {
            String stem = p.getStem().toLowerCase(Locale.ROOT);
            if (p.hasPositionalArgument()) {
                withArgMap.put(stem, p);
                continue;
            }
            withoutArgMap.put(stem, p);
        }
        this.withoutArgMap = Collections.unmodifiableMap(withoutArgMap);
        this.withArgMap = Collections.unmodifiableMap(withArgMap);
    }

    @NotNull
    public String getIdentifier() {
        return "xclaim";
    }

    @NotNull
    public String getAuthor() {
        return "WasabiThumbs @ Contributors";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Nullable
    public String onRequest(OfflinePlayer player, @NotNull String params) {
        int len = params.length();
        String lower = params.toLowerCase(Locale.ROOT);
        for (int i = len - 1; i >= 0; --i) {
            Placeholder withArg;
            char c = lower.charAt(i);
            if (c != '_' || (withArg = this.withArgMap.get(lower.substring(0, i))) == null) continue;
            return withArg.computeFor(player, params.substring(i + 1));
        }
        Placeholder withoutArg = this.withoutArgMap.get(lower);
        if (withoutArg != null) {
            return withoutArg.computeFor(player, null);
        }
        return null;
    }
}

