/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.placeholder;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.placeholder.Placeholder;
import codes.wasabi.xclaim.placeholder.impl.CountInWorldPlaceholder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public final class Placeholders {
    public static final Placeholder CLAIM_COUNT = Placeholder.simple("claim_count", o -> Integer.toString(Claim.getByOwner(o).size()));
    public static final Placeholder CLAIM_COUNT_IN_WORLD = new CountInWorldPlaceholder(false);
    public static final Placeholder CLAIM_MAX = Placeholder.simple("claim_max", o -> Integer.toString(XCPlayer.of(o).getMaxClaims()));
    public static final Placeholder CHUNK_COUNT = Placeholder.simple("chunk_count", o -> Integer.toString(Claim.getByOwner(o).stream().mapToInt(c -> c.getChunks().size()).sum()));
    public static final Placeholder CHUNK_COUNT_IN_WORLD = new CountInWorldPlaceholder(true);
    public static final Placeholder CHUNK_MAX = Placeholder.simple("chunk_max", o -> Integer.toString(XCPlayer.of(o).getMaxChunks()));
    public static final Placeholder CHUNK_ABS_MAX = Placeholder.simple("chunk_max_abs", o -> Integer.toString(XCPlayer.of(o).getMaxChunks() * XCPlayer.of(o).getMaxClaims()));

    @NotNull
    public static @NotNull Placeholder @NotNull [] values() {
        Field[] declaredFields = Placeholders.class.getDeclaredFields();
        Placeholder[] ret = new Placeholder[declaredFields.length];
        int i = 0;
        for (Field f : declaredFields) {
            Placeholder value;
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !Placeholder.class.isAssignableFrom(f.getType())) continue;
            try {
                value = (Placeholder)f.get(null);
            }
            catch (ReflectiveOperationException | SecurityException e) {
                XClaim.logger.log(Level.WARNING, "Unexpected error while enumerating placeholders", e);
                continue;
            }
            ret[i++] = value;
        }
        if (i < declaredFields.length) {
            Placeholder[] cpy = new Placeholder[i];
            System.arraycopy(ret, 0, cpy, 0, i);
            return cpy;
        }
        return ret;
    }
}

