/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Point
implements Comparable<Point> {
    private final int x;
    private final int y;

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public final int x() {
        return this.x;
    }

    public final int y() {
        return this.y;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public Point sum(int x, int y) {
        return new Point(this.x() + x, this.y() + y);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public Point product(int x, int y) {
        return new Point(this.x() * x, this.y() * y);
    }

    @Contract(value="_ -> new")
    @NotNull
    public Point product(int scale) {
        return this.product(scale, scale);
    }

    @Override
    public int compareTo(@NotNull Point other) {
        if (this.x != other.x) {
            return Double.compare(this.x, other.x);
        }
        return Double.compare(this.y, other.y);
    }

    public int hashCode() {
        return 31 * (31 + this.x) + this.y;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Point) {
            Point other = (Point)obj;
            if (other.x == this.x && other.y == this.y) {
                return true;
            }
        }
        return super.equals(obj);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

