/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map.util;

import codes.wasabi.xclaim.map.util.Bitmap;
import codes.wasabi.xclaim.map.util.Point;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.util.ChunkReference;
import codes.wasabi.xclaim.util.IntLongConverter;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class ChunkBitmap
implements Bitmap {
    private int originX;
    private int originZ;
    private int width;
    private int height;
    private World world;
    private LongSet indices;

    public ChunkBitmap() {
        this.clear();
    }

    public ChunkBitmap(@NotNull Collection<ChunkReference> chunks) {
        this.setChunks(chunks);
    }

    public ChunkBitmap(ChunkReference ... chunks) {
        this.setChunks(Arrays.asList(chunks));
    }

    public void clear() {
        this.originX = 0;
        this.originZ = 0;
        this.width = 0;
        this.height = 0;
        this.world = null;
        this.indices = LongSets.emptySet();
    }

    public void setChunks(@NotNull Collection<ChunkReference> chunks) {
        int size = chunks.size();
        if (size == 0) {
            this.clear();
        } else {
            this.indices = new LongLinkedOpenHashSet(size);
            int xMin = Integer.MAX_VALUE;
            int zMin = Integer.MAX_VALUE;
            int xMax = Integer.MIN_VALUE;
            int zMax = Integer.MIN_VALUE;
            for (ChunkReference c : chunks) {
                this.world = c.world;
                xMin = Math.min(xMin, c.x);
                xMax = Math.max(xMax, c.x);
                zMin = Math.min(zMin, c.z);
                zMax = Math.max(zMax, c.z);
            }
            ChunkReference originChunk = new ChunkReference(this.world, xMin, zMin);
            Location originBlock = originChunk.getLocation(0.0, Platform.get().getWorldMinHeight(this.world), 0.0);
            this.originX = originBlock.getBlockX();
            this.originZ = originBlock.getBlockZ();
            this.width = xMax - xMin + 1;
            this.height = zMax - zMin + 1;
            for (ChunkReference c : chunks) {
                this.indices.add(IntLongConverter.intToLong(c.x - xMin, c.z - zMin));
            }
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean getPixel(int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        if (x >= this.width) {
            return false;
        }
        if (y >= this.height) {
            return false;
        }
        long idx = IntLongConverter.intToLong(x, y);
        return this.indices.contains(idx);
    }

    private List<Point> transformPoints(List<Point> points) {
        int size = points.size();
        Point[] transformed = new Point[size];
        for (int i = 0; i < size; ++i) {
            transformed[i] = points.get(i).product(16).sum(this.originX, this.originZ);
        }
        return Arrays.asList(transformed);
    }

    public List<Point> traceBlocks() {
        return this.transformPoints(Bitmap.super.trace());
    }

    public List<List<Point>> traceBlocks(boolean includeAll) {
        return Bitmap.super.trace(includeAll).stream().map(this::transformPoints).collect(Collectors.toList());
    }
}

