/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map.util;

import codes.wasabi.xclaim.map.util.Bitmap;
import codes.wasabi.xclaim.map.util.Point;
import org.jetbrains.annotations.Nullable;

public class ArrayBitmap
implements Bitmap {
    private static final byte FULL_BYTE = -1;
    private final byte[] data;
    private final int width;
    private final int height;

    protected ArrayBitmap(byte[] data, int width, int height) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    public ArrayBitmap(int width, int height) throws IllegalArgumentException {
        if (width < 0) {
            throw new IllegalArgumentException("Width cannot be negative");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height cannot be negative");
        }
        int bytes = (int)(((long)width * (long)height - 1L >> 3) + 1L);
        this.data = new byte[bytes];
        this.width = width;
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean getPixel(int x, int y) {
        if (x < 0 || x >= this.width) {
            return false;
        }
        if (y < 0 || y >= this.height) {
            return false;
        }
        int index = y * this.width + x;
        int byteIndex = index >> 3;
        byte flag = (byte)(1 << (index & 7));
        return (this.data[byteIndex] & flag) == flag;
    }

    public void setPixel(int x, int y) {
        this.setPixel(x, y, true);
    }

    public void setPixel(int x, int y, boolean value) {
        if (x < 0 || x >= this.width) {
            throw new IndexOutOfBoundsException("X " + x + " out of bounds for width " + this.width);
        }
        if (y < 0 || y >= this.height) {
            throw new IndexOutOfBoundsException("Y " + x + " out of bounds for height " + this.height);
        }
        int index = y * this.width + x;
        int byteIndex = index >> 3;
        int flag = 1 << (index & 7);
        if (value) {
            int n = byteIndex;
            this.data[n] = (byte)(this.data[n] | (byte)flag);
        } else {
            int n = byteIndex;
            this.data[n] = (byte)(this.data[n] & (byte)(~flag));
        }
    }

    @Nullable
    public Point firstUnset() {
        byte b = 0;
        int bIndex = -1;
        for (int i = 0; i < this.data.length; ++i) {
            b = this.data[i];
            if (b == -1) continue;
            bIndex = i;
            break;
        }
        if (bIndex == -1) {
            return null;
        }
        bIndex <<= 3;
        int ib = b & 0xFF;
        if (ib != 0) {
            int startBit = Integer.numberOfTrailingZeros(~ib);
            int endBit = 32 - Integer.numberOfLeadingZeros(ib);
            for (int z = startBit; z <= endBit; ++z) {
                int flag = 1 << z;
                if ((ib & flag) != 0) continue;
                bIndex |= z;
                break;
            }
        }
        int y = Math.floorDiv(bIndex, this.width);
        int x = bIndex - y * this.width;
        return new Point(x, y);
    }
}

