/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map.impl.dynmap;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.map.MapMarker;
import codes.wasabi.xclaim.map.MapService;
import codes.wasabi.xclaim.map.exception.MapServiceInitException;
import java.lang.reflect.Field;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynmapMapService
extends MapService {
    private final Plugin plugin = this.findPlugin("dynmap");

    public DynmapMapService() throws MapServiceInitException {
        Class<Plugin> clazz = this.findClass("org.dynmap.bukkit.DynmapPlugin", Plugin.class);
        if (!clazz.isInstance(this.plugin)) {
            throw new MapServiceInitException("Dynmap plugin is class \"" + this.plugin.getClass().getName() + "\", not \"" + clazz.getName() + "\"");
        }
        boolean corePresent = false;
        try {
            Field f = clazz.getDeclaredField("core");
            try {
                f.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            corePresent = f.get(this.plugin) != null;
        }
        catch (Exception e) {
            XClaim.logger.log(Level.WARNING, XClaim.lang.get("dynmap-warn-core"));
        }
        if (!corePresent) {
            throw new MapServiceInitException("Dynmap plugin core is null");
        }
    }

    @Override
    @Nullable
    public MapMarker getMarker(@NotNull Claim claim) {
        try {
            Class<?> apiClass = Class.forName("org.dynmap.DynmapAPI");
            return (MapMarker)Class.forName("codes.wasabi.xclaim.map.impl.dynmap.DynmapMapMarker").getDeclaredMethod("getMarker", apiClass, Claim.class).invoke(null, apiClass.cast(this.plugin), claim);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void cleanup() {
        try {
            Class<?> apiClass = Class.forName("org.dynmap.DynmapAPI");
            Class.forName("codes.wasabi.xclaim.map.impl.dynmap.DynmapMapMarker").getDeclaredMethod("cleanMarkerSet", apiClass).invoke(null, apiClass.cast(this.plugin));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

