/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.map.impl.bluemap;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.map.MapMarker;
import codes.wasabi.xclaim.map.util.ChunkBitmap;
import codes.wasabi.xclaim.map.util.ClaimUtil;
import codes.wasabi.xclaim.map.util.Point;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.util.BoundingBox;
import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.math.Shape;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BluemapMapMarker
implements MapMarker {
    private final MarkerSet set;
    private final ExtrudeMarker marker;
    private static final String markerSetId = "xclaim_marker_set";
    private static final Map<UUID, MarkerSet> markerSetMap = new HashMap<UUID, MarkerSet>();

    public BluemapMapMarker(MarkerSet set, ExtrudeMarker marker) {
        this.set = set;
        this.marker = marker;
    }

    public ExtrudeMarker get() {
        return this.marker;
    }

    private Shape buildShapeFromPoints(List<Point> points) {
        Shape.Builder shapeBuilder = Shape.builder();
        for (Point p : points) {
            shapeBuilder.addPoint(Vector2d.from((double)p.x(), (double)p.y()));
        }
        return shapeBuilder.build();
    }

    @Override
    public void update(@NotNull Claim claim) {
        ChunkBitmap bmp = new ChunkBitmap(claim.getChunks());
        List<List<Point>> edges = bmp.traceBlocks(true);
        if (edges.isEmpty()) {
            return;
        }
        this.marker.setShape(this.buildShapeFromPoints(edges.get(0)), this.marker.getShapeMinY(), this.marker.getShapeMaxY());
        Collection holes = this.marker.getHoles();
        holes.clear();
        for (int i = 1; i < edges.size(); ++i) {
            holes.add(this.buildShapeFromPoints(edges.get(i)));
        }
    }

    @Override
    public void deleteMarker() {
        new HashSet(this.set.getMarkers().entrySet()).stream().filter(entry -> Objects.equals(entry.getValue(), this.marker)).map(Map.Entry::getKey).forEach(arg_0 -> ((MarkerSet)this.set).remove(arg_0));
    }

    @Nullable
    private static MarkerSet getMarkerSet(BlueMapAPI api, Claim claim) {
        World world = claim.getWorld();
        if (world == null) {
            return null;
        }
        UUID uuid = world.getUID();
        if (markerSetMap.containsKey(uuid)) {
            return markerSetMap.get(uuid);
        }
        Optional opt = api.getWorld((Object)world);
        if (!opt.isPresent()) {
            return null;
        }
        BlueMapWorld bmw = (BlueMapWorld)opt.get();
        MarkerSet ms = MarkerSet.builder().label(XClaim.lang.get("dynmap-marker-name")).build();
        markerSetMap.put(uuid, ms);
        for (BlueMapMap map : bmw.getMaps()) {
            map.getMarkerSets().put(markerSetId, ms);
        }
        return ms;
    }

    @Nullable
    static BluemapMapMarker getMarker(Object apiInstance, Claim claim) {
        BlueMapAPI api = (BlueMapAPI)apiInstance;
        MarkerSet ms = BluemapMapMarker.getMarkerSet(api, claim);
        if (ms == null) {
            return null;
        }
        String token = claim.getUniqueToken();
        Marker existing = ms.get(token);
        if (existing != null) {
            if (existing instanceof ExtrudeMarker) {
                return new BluemapMapMarker(ms, (ExtrudeMarker)existing);
            }
            ms.remove(token);
        }
        BoundingBox bounds = claim.getOuterBounds();
        Vector mins = bounds.getMins();
        Vector maxs = bounds.getMaxs();
        World world = claim.getWorld();
        if (world == null) {
            world = (World)Bukkit.getWorlds().stream().findFirst().orElseThrow(null);
        }
        Color col = ClaimUtil.getClaimColor(claim);
        ExtrudeMarker marker = ((ExtrudeMarker.Builder)ExtrudeMarker.builder().shape(Shape.createRect((double)mins.getX(), (double)mins.getZ(), (double)maxs.getX(), (double)maxs.getZ()), (float)Platform.get().getWorldMinHeight(world), (float)world.getMaxHeight()).label(claim.getName())).fillColor(new de.bluecolored.bluemap.api.math.Color(col.getRed(), col.getGreen(), col.getBlue(), 0.2f)).lineColor(new de.bluecolored.bluemap.api.math.Color(col.getRed(), col.getGreen(), col.getBlue(), 0.4f)).build();
        ms.put(token, (Marker)marker);
        return new BluemapMapMarker(ms, marker);
    }

    static void cleanup(Object apiInstance) {
        BlueMapAPI api = (BlueMapAPI)apiInstance;
        for (BlueMapMap map : api.getMaps()) {
            map.getMarkerSets().remove(markerSetId);
        }
    }
}

