/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.spec.impl.derived;

import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.gui2.GuiInstance;
import codes.wasabi.xclaim.gui2.action.GuiAction;
import codes.wasabi.xclaim.gui2.spec.GuiSpec;
import codes.wasabi.xclaim.gui2.spec.GuiSpecs;
import codes.wasabi.xclaim.gui2.spec.impl.PlayerListGuiSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public final class PermissiblePlayerListGuiSpec
extends PlayerListGuiSpec {
    private final Claim claim;
    private final Set<XCPlayer> added = new LinkedHashSet<XCPlayer>();

    public PermissiblePlayerListGuiSpec(@NotNull Claim claim) {
        this.claim = claim;
    }

    @Override
    protected boolean addPlayer(@NotNull GuiInstance instance, @NotNull OfflinePlayer player) {
        return this.added.add(XCPlayer.of(player));
    }

    @Override
    @NotNull
    protected Collection<OfflinePlayer> getEntries(@NotNull GuiInstance instance) {
        Set<XCPlayer> intrinsic = this.claim.getUserPermissions().keySet();
        int intrinsicCount = intrinsic.size();
        ArrayList<OfflinePlayer> ret = new ArrayList<OfflinePlayer>(intrinsicCount + this.added.size());
        for (XCPlayer ply : intrinsic) {
            ret.add(ply.getOfflinePlayer());
        }
        for (XCPlayer ply : this.added) {
            if (intrinsic.contains(ply)) continue;
            ret.add(ply.getOfflinePlayer());
        }
        ret.subList(0, intrinsicCount).sort(Comparator.comparing(OfflinePlayer::getName));
        return ret;
    }

    @Override
    @NotNull
    protected GuiAction onClickEntry(@NotNull GuiInstance instance, @NotNull OfflinePlayer entry) {
        return GuiAction.transfer(GuiSpecs.individualPermissionList(this.claim, entry));
    }

    @Override
    @NotNull
    protected GuiSpec getReturn() {
        return GuiSpecs.permissionOverview(this.claim);
    }
}

