/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.layout.map;

import codes.wasabi.xclaim.gui2.layout.GuiLayout;
import codes.wasabi.xclaim.gui2.layout.map.GuiSlotMap;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

@ApiStatus.Internal
class U4GuiSlotMap
extends GuiSlotMap {
    private final byte[] data;

    public U4GuiSlotMap(@NotNull GuiLayout layout) {
        super(layout);
        int size = (this.w * this.h - 1 >> 1) + 1;
        this.data = new byte[size];
        Arrays.fill(this.data, (byte)-1);
        this.populate(layout);
    }

    @Override
    public int max() {
        return 14;
    }

    @Override
    public @Range(from=-1L, to=14L) int get(int x, int y) {
        if (this.oob(x, y)) {
            return -1;
        }
        int index = this.calculateIndex(x, y);
        int octet = Byte.toUnsignedInt(this.data[index >> 1]);
        octet = (index & 1) == 1 ? (octet >>= 4) : (octet &= 0xF);
        return octet == 15 ? -1 : octet;
    }

    @Override
    protected void set(int x, int y, int value) {
        int index = this.calculateIndex(x, y);
        int bIndex = index >> 1;
        byte data = this.data[bIndex];
        if ((index & 1) == 1) {
            data = (byte)(data & 0xF);
            data = (byte)(data | (byte)(value << 4));
        } else {
            data = (byte)(data & 0xFFFFFFF0);
            data = (byte)(data | (byte)value);
        }
        this.data[bIndex] = data;
    }
}

