/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.layout;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.gui2.layout.GuiLayout;
import codes.wasabi.xclaim.gui2.layout.xml.XmlGuiLayout;
import codes.wasabi.xclaim.util.io.CloseListenerInputStream;
import codes.wasabi.xclaim.util.io.TeeInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.StampedLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class GuiLayouts {
    private static final Pattern FILE_PATTERN = Pattern.compile("^layouts/([a-z\\-]+)\\.xml$");
    private LoadStage stage = LoadStage.IDLE;
    private final StampedLock stageLock = new StampedLock();
    private Throwable fatal = null;
    private final Object endPreEntriesSignal = new Object();
    protected LinkedList<LoadEntry> entries = new LinkedList();
    private Map<String, LoadResult> map = new HashMap<String, LoadResult>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    public GuiLayout get(@NotNull String name) {
        LoadResult lr = null;
        long stamp = this.stageLock.readLock();
        try {
            switch (this.stage.ordinal()) {
                case 0: {
                    stamp = this.startLoadingInternal(stamp);
                    stamp = this.stageLock.tryConvertToReadLock(stamp);
                }
                case 2: {
                    Iterator iterator = this.endPreEntriesSignal;
                    // MONITORENTER : iterator
                    this.stageLock.unlock(stamp);
                    try {
                        this.endPreEntriesSignal.wait();
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError("Awaiting entry resolution for \"" + name + "\" was interrupted", e);
                    }
                    stamp = this.stageLock.readLock();
                    // MONITOREXIT : iterator
                    if (this.stage == LoadStage.FATAL) {
                        this.throwFatal();
                    }
                }
                case 3: {
                    for (LoadEntry le : this.entries) {
                        if (!name.equals(le.name)) continue;
                        lr = LoadResult.ofFuture(le.value, true);
                    }
                    break;
                }
                case 1: {
                    this.throwFatal();
                    GuiLayout guiLayout = null;
                    return guiLayout;
                }
                case 4: {
                    lr = this.map.get(name);
                    break;
                }
            }
        }
        finally {
            this.stageLock.unlock(stamp);
        }
        if (lr == null) {
            return null;
        }
        if (!lr.success()) throw new AssertionError("Failed to load data for layout \"" + name + "\"", lr.error());
        return lr.value();
    }

    public void startLoading() {
        long stamp = this.stageLock.readLock();
        try {
            if (this.stage == LoadStage.IDLE) {
                stamp = this.startLoadingInternal(stamp);
            }
        }
        finally {
            this.stageLock.unlock(stamp);
        }
    }

    private long startLoadingInternal(long stamp) {
        stamp = this.stageLock.tryConvertToWriteLock(stamp);
        LoadWorker worker = new LoadWorker(this);
        this.stage = LoadStage.PRE_ENTRIES;
        worker.start();
        return stamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPostEntries() {
        long stamp = this.stageLock.writeLock();
        try {
            this.stage = LoadStage.POST_ENTRIES;
            Object object = this.endPreEntriesSignal;
            synchronized (object) {
                this.endPreEntriesSignal.notify();
            }
        }
        finally {
            this.stageLock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFatal(@NotNull Throwable err) {
        long stamp = this.stageLock.writeLock();
        try {
            this.stage = LoadStage.FATAL;
            this.fatal = err;
            Object object = this.endPreEntriesSignal;
            synchronized (object) {
                this.endPreEntriesSignal.notify();
            }
        }
        finally {
            this.stageLock.unlock(stamp);
        }
    }

    @Contract(value=" -> fail")
    private void throwFatal() {
        throw new AssertionError("Layout loader threw a fatal exception", this.fatal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transferEntries() {
        long stamp = this.stageLock.writeLock();
        try {
            LoadEntry entry;
            while ((entry = this.entries.pollLast()) != null) {
                this.map.put(entry.name, LoadResult.ofFuture(entry.value, false));
            }
            this.map = Collections.unmodifiableMap(this.map);
            this.stage = LoadStage.DONE;
        }
        finally {
            this.stageLock.unlock(stamp);
        }
    }

    protected static enum LoadStage {
        IDLE,
        FATAL,
        PRE_ENTRIES,
        POST_ENTRIES,
        DONE;

    }

    protected static class LoadEntry {
        final String name;
        final String bundledPath;
        final File diskPath;
        final CompletableFuture<GuiLayout> value = new CompletableFuture();

        LoadEntry(@NotNull String name, @NotNull String bundledPath, @NotNull File diskPath) {
            this.name = name;
            this.bundledPath = bundledPath;
            this.diskPath = diskPath;
        }
    }

    protected static interface LoadResult {
        @NotNull
        public static LoadResult success(@NotNull GuiLayout value) {
            return new Success(value);
        }

        @NotNull
        public static LoadResult error(@NotNull Throwable cause) {
            return new Error(cause);
        }

        @NotNull
        public static LoadResult ofFuture(@NotNull CompletableFuture<GuiLayout> future, boolean wait) {
            try {
                GuiLayout value;
                GuiLayout guiLayout = value = wait ? future.get() : (GuiLayout)future.getNow(null);
                if (value != null) {
                    return LoadResult.success(value);
                }
                return LoadResult.error(new IllegalStateException("Result was unwrapped before resolution"));
            }
            catch (CompletionException | ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                return LoadResult.error(cause);
            }
            catch (InterruptedException e) {
                return LoadResult.error(e);
            }
        }

        public boolean success();

        public @UnknownNullability GuiLayout value();

        public @UnknownNullability Throwable error();

        public static class Success
        implements LoadResult {
            private final GuiLayout value;

            Success(@NotNull GuiLayout value) {
                this.value = value;
            }

            @Override
            @Contract(value=" -> true")
            public boolean success() {
                return true;
            }

            @Override
            @NotNull
            public GuiLayout value() {
                return this.value;
            }

            @Override
            @Contract(value=" -> null")
            public Throwable error() {
                return null;
            }
        }

        public static class Error
        implements LoadResult {
            private final Throwable error;

            Error(@NotNull Throwable error) {
                this.error = error;
            }

            @Override
            @Contract(value=" -> false")
            public boolean success() {
                return false;
            }

            @Override
            @Contract(value=" -> null")
            public GuiLayout value() {
                return null;
            }

            @Override
            @NotNull
            public Throwable error() {
                return this.error;
            }
        }
    }

    protected static class LoadWorker
    extends Thread {
        final GuiLayouts parent;

        LoadWorker(@NotNull GuiLayouts parent) {
            super("XClaim GUI Layout Loader");
            this.parent = parent;
        }

        @Override
        public void run() {
            try {
                this.populateEntries();
            }
            catch (IOException e) {
                this.parent.setFatal(e);
                return;
            }
            this.parent.setPostEntries();
            for (LoadEntry le : this.parent.entries) {
                try {
                    GuiLayout layout = this.resolveEntry(le);
                    le.value.complete(layout);
                }
                catch (IOException e) {
                    le.value.completeExceptionally(e);
                }
            }
            this.parent.transferEntries();
        }

        private void populateEntries() throws IOException {
            File dataFolder = XClaim.instance.getDataFolder();
            File layoutsFolder = new File(dataFolder, "layouts");
            if (!layoutsFolder.isDirectory() && !layoutsFolder.mkdirs()) {
                throw new IOException("Failed to create new directory: " + layoutsFolder.getAbsolutePath());
            }
            try (FileInputStream fis = new FileInputStream(XClaim.jarFile);
                 ZipInputStream zis = new ZipInputStream(fis);){
                ZipEntry ze;
                while ((ze = zis.getNextEntry()) != null) {
                    Matcher m = FILE_PATTERN.matcher(ze.getName());
                    if (!m.matches()) continue;
                    LoadEntry entry = new LoadEntry(m.group(1), ze.getName(), new File(layoutsFolder, m.group(1) + ".xml"));
                    this.parent.entries.add(entry);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        private GuiLayout resolveEntry(@NotNull LoadEntry entry) throws IOException {
            InputStream is;
            File diskPath = entry.diskPath;
            if (diskPath.isFile()) {
                is = new FileInputStream(diskPath);
            } else {
                boolean close = true;
                ZipFile zf = null;
                is = null;
                try {
                    zf = new ZipFile(XClaim.jarFile);
                    ZipEntry ze = zf.getEntry(entry.bundledPath);
                    if (ze == null) {
                        throw new IOException("Entry \"" + entry.bundledPath + "\" no longer exists");
                    }
                    is = zf.getInputStream(ze);
                    is = new TeeInputStream(is, new FileOutputStream(diskPath, false));
                    is = new CloseListenerInputStream(is, zf);
                    close = false;
                }
                finally {
                    if (close) {
                        if (zf != null) {
                            zf.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                    }
                }
            }
            try {
                XmlGuiLayout ret = new XmlGuiLayout(XClaim.mainConfig.gui().height());
                ret.setDefaultBasis(XClaim.mainConfig.gui().basis());
                ret.read(is);
                XmlGuiLayout xmlGuiLayout = ret;
                return xmlGuiLayout;
            }
            finally {
                is.close();
            }
        }
    }
}

