/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.layout;

import org.jetbrains.annotations.Range;

public enum GuiBasis {
    LEFT,
    CENTER,
    EVEN,
    RIGHT;

    private static final byte[][] EVEN_TABLE;

    private static int organizeEven(int index, int innerSize, @Range(from=3L, to=9L) int outerSize) {
        if (innerSize > 1) {
            index += Math.floorDiv(innerSize * (innerSize - 1), 2);
        }
        int value = Byte.toUnsignedInt(EVEN_TABLE[9 - outerSize][index >> 1]);
        return (index & 1) == 1 ? value & 0xF : value >> 4;
    }

    public int organize(int index, int innerSize, int outerSize) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative");
        }
        if (index >= innerSize) {
            throw new IndexOutOfBoundsException("Index cannot meet or exceed inner size");
        }
        if (innerSize >= outerSize) {
            return Math.min(index, outerSize - 1);
        }
        switch (this.ordinal()) {
            case 2: {
                if (outerSize == 2) {
                    return 0;
                }
                if (outerSize > 9) {
                    throw new IllegalArgumentException("Outer size cannot be more than 9");
                }
                return GuiBasis.organizeEven(index, innerSize, outerSize);
            }
            case 3: {
                return outerSize - 1 - index;
            }
            case 1: {
                return Math.floorDiv(outerSize - innerSize, 2) + index;
            }
        }
        return index;
    }

    public int unorganize(int index, int innerSize, int outerSize) {
        switch (this.ordinal()) {
            case 2: {
                if (outerSize == 2) {
                    return 0;
                }
                for (int z = 0; z < innerSize; ++z) {
                    if (GuiBasis.organizeEven(z, innerSize, outerSize) != index) continue;
                    return z;
                }
                break;
            }
            case 3: {
                return outerSize - 1 - index;
            }
            case 1: {
                return Math.floorDiv(outerSize - innerSize, 2) + innerSize - 1 - index;
            }
        }
        return index;
    }

    public char getChar() {
        switch (this.ordinal()) {
            case 0: {
                return '[';
            }
            case 3: {
                return ']';
            }
            case 1: {
                return 'o';
            }
            case 2: {
                return '-';
            }
        }
        return '?';
    }

    static {
        EVEN_TABLE = new byte[][]{{66, 97, 71, 19, 87, 2, 70, -127, 35, 86, 113, 35, 69, 103, 1, 35, 86, 120}, {50, 81, 53, 2, 70, 2, 53, 112, 35, 69, 112, 18, 52, 87}, {50, 65, 53, 2, 70, 2, 52, 96, 18, 69, 96}, {33, 64, 36, 18, 52, 1, 35, 64}, {33, 49, 35, 1, 52}, {17, 32, 18}, {16, 32}};
    }
}

