/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2.action;

import codes.wasabi.xclaim.gui2.action.GuiActionType;
import codes.wasabi.xclaim.gui2.action.impl.ExitGuiAction;
import codes.wasabi.xclaim.gui2.action.impl.NothingGuiAction;
import codes.wasabi.xclaim.gui2.action.impl.PromptGuiAction;
import codes.wasabi.xclaim.gui2.action.impl.RepopulateGuiAction;
import codes.wasabi.xclaim.gui2.action.impl.TransferGuiAction;
import codes.wasabi.xclaim.gui2.spec.GuiSpec;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface GuiAction {
    @Contract(pure=true)
    @NotNull
    public static GuiAction nothing() {
        return NothingGuiAction.INSTANCE;
    }

    @Contract(pure=true)
    @NotNull
    public static GuiAction repopulate() {
        return RepopulateGuiAction.INSTANCE;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static GuiAction transfer(@NotNull GuiSpec target) {
        return new TransferGuiAction(target);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static GuiAction prompt(@NotNull Component message) {
        return new PromptGuiAction(message);
    }

    @Contract(pure=true)
    @NotNull
    public static GuiAction exit() {
        return ExitGuiAction.INSTANCE;
    }

    @NotNull
    public GuiActionType type();
}

