/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2;

import codes.wasabi.xclaim.config.struct.sub.GuiConfig;
import codes.wasabi.xclaim.gui.GUIHandler;
import codes.wasabi.xclaim.gui2.GuiManager;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public interface GuiService {
    @NotNull
    public static GuiService create(@NotNull GuiConfig.Version version) {
        switch (version) {
            case V1: {
                return new Legacy();
            }
            case V2: {
                return new GuiManager();
            }
        }
        throw new AssertionError();
    }

    public void start();

    public void stop();

    public void openGui(@NotNull Player var1);

    public static final class Legacy
    implements GuiService {
        @Override
        public void start() {
        }

        @Override
        public void stop() {
            GUIHandler.closeAll();
        }

        @Override
        public void openGui(@NotNull Player target) {
            new GUIHandler(target);
        }
    }
}

