/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui2;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.gui2.GuiManager;
import codes.wasabi.xclaim.gui2.action.GuiAction;
import codes.wasabi.xclaim.gui2.action.GuiActionType;
import codes.wasabi.xclaim.gui2.action.impl.PromptGuiAction;
import codes.wasabi.xclaim.gui2.action.impl.TransferGuiAction;
import codes.wasabi.xclaim.gui2.dialog.GuiDialog;
import codes.wasabi.xclaim.gui2.layout.GuiLayout;
import codes.wasabi.xclaim.gui2.layout.GuiSlot;
import codes.wasabi.xclaim.gui2.layout.map.GuiSlotMap;
import codes.wasabi.xclaim.gui2.spec.GuiSpec;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiInstance
implements InventoryHolder {
    private final GuiManager manager;
    private final Player player;
    private GuiSpec spec;
    private GuiLayout layout;
    private GuiSlotMap slotMap;
    private Inventory inventory;
    private GuiDialog dialog = null;

    @NotNull
    public static GuiInstance open(@NotNull GuiManager manager, @NotNull Player player, @NotNull GuiSpec spec) {
        GuiInstance ret = new GuiInstance(manager, player);
        ret.setSpecInternal(spec, 6);
        ret.inventory = Platform.get().createInventory(ret, 9 * ret.layout.getHeight(), XClaim.lang.getComponent("gui-name"));
        ret.populate();
        player.openInventory(ret.inventory);
        return ret;
    }

    GuiInstance(@NotNull GuiManager manager, @NotNull Player player) {
        this.manager = manager;
        this.player = player;
    }

    public synchronized void setSpec(@NotNull GuiSpec spec) {
        if (spec != this.spec) {
            this.setSpecInternal(spec, this.layout.getHeight());
        }
        this.populate();
    }

    protected synchronized void setSpecInternal(@NotNull GuiSpec spec, int heightLimit) {
        GuiLayout layout = this.manager.layouts().get(spec.layout());
        if (layout == null) {
            throw new IllegalArgumentException("Layout \"" + spec.layout() + "\" required by spec " + spec.getClass().getName() + " not found");
        }
        if (layout.getHeight() > heightLimit) {
            throw new IllegalArgumentException("Layout \"" + spec.layout() + "\" required by spec " + spec.getClass().getName() + " is too tall (limit: " + heightLimit + ", got: " + layout.getHeight() + ")");
        }
        this.spec = spec;
        this.layout = layout;
        this.slotMap = GuiSlotMap.create(layout);
    }

    protected synchronized void populate() {
        this.inventory.clear();
        this.spec.populate(this);
    }

    @NotNull
    public GuiManager manager() {
        return this.manager;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    public Inventory inventory() {
        return this.inventory;
    }

    @NotNull
    public Player player() {
        return this.player;
    }

    @NotNull
    public Audience audience() {
        return Platform.getAdventure().player(this.player);
    }

    public void playSound(@NotNull Sound sound, float volume, float pitch) {
        this.player.playSound(this.player.getLocation(), sound, volume, pitch);
    }

    @Nullable
    public synchronized GuiSlot getSlot(int index) {
        return this.layout.getSlot(index);
    }

    public void set(@Nullable GuiSlot slot, int index, @Nullable ItemStack item) {
        if (slot == null) {
            return;
        }
        int lw = this.layout.getWidth();
        int sw = slot.width();
        int y = Math.floorDiv(index, sw);
        int x = index - y * sw;
        this.inventory.setItem((y + slot.y()) * lw + x + slot.x(), item);
    }

    public void set(int slotIndex, int index, @Nullable ItemStack item) {
        this.set(this.getSlot(slotIndex), index, item);
    }

    public void set(@Nullable GuiSlot slot, @Nullable ItemStack item) {
        this.set(slot, 0, item);
    }

    public void set(int slotIndex, @Nullable ItemStack item) {
        this.set(this.getSlot(slotIndex), 0, item);
    }

    public void close() {
        this.destroyPrompt();
        this.manager.untrack(this);
        this.inventory.close();
    }

    public void prompt(@NotNull Component message) {
        this.manager.addChatTicket(this.player, this);
        this.inventory.close();
        this.dialog = GuiDialog.show(this.player, message);
    }

    protected void destroyPrompt() {
        if (this.dialog != null) {
            this.dialog.close();
        }
        this.dialog = null;
    }

    public void executeAction(@NotNull GuiAction action) {
        switch (action.type()) {
            case EXIT: {
                this.close();
                break;
            }
            case REPOPULATE: {
                this.populate();
                break;
            }
            case PROMPT: {
                this.prompt(((PromptGuiAction)action).message());
                break;
            }
            case TRANSFER: {
                this.setSpec(((TransferGuiAction)action).target());
            }
        }
    }

    public void click(int slot) {
        int y = Math.floorDiv(slot, 9);
        int x = slot - y * 9;
        int idx = this.slotMap.get(x, y);
        if (idx == -1) {
            return;
        }
        GuiSlot ob = this.layout.getSlot(idx);
        if (ob == null) {
            return;
        }
        GuiAction act = this.spec.onClick(this, ob, ob.calculateLocalIndex(x, y));
        this.executeAction(act);
    }

    public void respond(@NotNull String message) {
        this.destroyPrompt();
        GuiAction act = this.spec.onResponse(this, message);
        if (act.type() == GuiActionType.EXIT) {
            this.manager.untrack(this);
            return;
        }
        this.executeAction(act);
        this.player.openInventory(this.inventory);
    }
}

