/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui.page;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.event.XClaimEvent;
import codes.wasabi.xclaim.api.event.XClaimTransferOwnerEvent;
import codes.wasabi.xclaim.gui.GUIHandler;
import codes.wasabi.xclaim.gui.Page;
import codes.wasabi.xclaim.gui.page.MainPage;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.util.DisplayItem;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class TransferPage
extends Page {
    private static final ItemStack YES_ITEM = DisplayItem.create(Platform.get().getGreenConcreteMaterial(), XClaim.lang.getComponent("gui-tx-yes"), Arrays.asList(XClaim.lang.getComponent("gui-tx-yes-line1"), XClaim.lang.getComponent("gui-tx-yes-line2"), XClaim.lang.getComponent("gui-tx-yes-line3")));
    private static final ItemStack NO_ITEM = DisplayItem.create(Platform.get().getRedConcreteMaterial(), XClaim.lang.getComponent("gui-tx-no"), Arrays.asList(XClaim.lang.getComponent("gui-tx-no-line1"), XClaim.lang.getComponent("gui-tx-no-line2")));
    private final Claim claim;
    private Player matchPlayer = null;

    public TransferPage(@NotNull GUIHandler parent, @NotNull Claim claim) {
        super(parent);
        this.claim = claim;
    }

    private void populate() {
        ItemStack head;
        if (this.matchPlayer != null) {
            head = Platform.get().preparePlayerSkull(DisplayItem.create(Platform.get().getPlayerHeadMaterial(), Platform.get().playerDisplayName(this.matchPlayer)));
            ItemMeta im = head.getItemMeta();
            if (im != null && im instanceof SkullMeta) {
                Platform.get().setOwningPlayer((SkullMeta)im, (OfflinePlayer)this.matchPlayer);
            }
            head.setItemMeta(im);
        } else {
            head = Platform.get().preparePlayerSkull(DisplayItem.create(Platform.get().getPlayerHeadMaterial(), XClaim.lang.get("unknown"), NamedTextColor.RED));
        }
        this.setItem(4, head);
        this.setItem(11, YES_ITEM);
        this.setItem(15, NO_ITEM);
    }

    @Override
    public void onEnter() {
        this.clear();
        this.prompt(XClaim.lang.get("gui-tx-prompt"), s -> {
            List matches = Bukkit.matchPlayer((String)s);
            if (matches.size() < 1) {
                Platform.getAdventure().player(this.getTarget()).sendMessage(XClaim.lang.getComponent("gui-tx-prompt-fail"));
                this.getParent().close();
                return;
            }
            this.matchPlayer = (Player)matches.get(0);
            this.populate();
        });
    }

    @Override
    public void onClick(int slot) {
        if (slot == 11) {
            if (this.matchPlayer != null) {
                Player target = this.getTarget();
                if (!XClaimEvent.dispatch(new XClaimTransferOwnerEvent(target, this.claim, this.claim.getOwner(), XCPlayer.of((OfflinePlayer)this.matchPlayer)))) {
                    this.getParent().close();
                    return;
                }
                this.claim.setOwner((OfflinePlayer)this.matchPlayer);
                this.claim.setUserPermission((OfflinePlayer)target, Permission.MANAGE, true);
                Platform.getAdventure().player(target).sendMessage(XClaim.lang.getComponent("gui-tx-success"));
                target.playSound(target.getLocation(), Platform.get().getLevelSound(), 1.0f, 1.0f);
                this.switchPage(new MainPage(this.getParent()));
            }
        } else if (slot == 15) {
            this.switchPage(new MainPage(this.getParent()));
        }
    }
}

