/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui.page;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.gui.GUIHandler;
import codes.wasabi.xclaim.gui.Page;
import codes.wasabi.xclaim.gui.page.MainPage;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.util.DisplayItem;
import codes.wasabi.xclaim.util.NameToPlayer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerCombinatorPage
extends Page {
    private int pageIndex = 0;
    private final Map<Integer, OfflinePlayer> assoc = new HashMap<Integer, OfflinePlayer>();

    @NotNull
    public static PlayerCombinatorPage withList(@NotNull GUIHandler parent, @NotNull List<OfflinePlayer> list) {
        return PlayerCombinatorPage.withList(parent, list, p -> {});
    }

    @NotNull
    public static PlayerCombinatorPage withList(@NotNull GUIHandler parent, final @NotNull List<OfflinePlayer> list, final @NotNull Consumer<OfflinePlayer> cb) {
        return new PlayerCombinatorPage(parent){

            @Override
            @NotNull
            protected List<OfflinePlayer> getList() {
                return list;
            }

            @Override
            protected void add(@NotNull OfflinePlayer ply) {
                list.add(ply);
            }

            @Override
            protected void remove(@NotNull OfflinePlayer ply) {
                list.remove(ply);
            }

            @Override
            protected void onSelect(@NotNull OfflinePlayer ply) {
                cb.accept(ply);
            }
        };
    }

    public PlayerCombinatorPage(@NotNull GUIHandler parent) {
        super(parent);
    }

    private void populate() {
        int listIndex;
        this.clear();
        List<OfflinePlayer> players = this.getList();
        int maxIndex = Math.max(players.size() - 1, 0) / 18;
        this.pageIndex = Math.min(Math.max(this.pageIndex, 0), maxIndex);
        int from = this.pageIndex * 18;
        this.assoc.clear();
        for (int i = 0; i < 18 && (listIndex = i + from) < players.size(); ++i) {
            OfflinePlayer ply = players.get(listIndex);
            this.assoc.put(i, ply);
            ItemStack is = Platform.get().preparePlayerSkull(new ItemStack(Platform.get().getPlayerHeadMaterial(), 1));
            ItemMeta meta = is.getItemMeta();
            if (meta != null) {
                String realName = ply.getName();
                if (realName == null) {
                    realName = ply.getUniqueId().toString();
                }
                Component niceName = ply instanceof Player ? Platform.get().playerDisplayName((Player)ply) : Component.text(realName);
                meta.addItemFlags(ItemFlag.values());
                Platform.get().metaDisplayName(meta, niceName);
                Platform.get().metaLore(meta, Collections.singletonList(Component.text(realName).color(NamedTextColor.GRAY)));
                if (meta instanceof SkullMeta) {
                    Platform.get().setOwningPlayer((SkullMeta)meta, ply);
                }
            }
            is.setItemMeta(meta);
            this.setItem(i, is);
        }
        if (this.pageIndex > 0) {
            this.setItem(18, DisplayItem.create(Material.ARROW, XClaim.lang.getComponent("gui-comb-previous")));
        }
        if (this.pageIndex < maxIndex) {
            this.setItem(26, DisplayItem.create(Material.ARROW, XClaim.lang.getComponent("gui-comb-next")));
        }
        this.setItem(21, DisplayItem.create(Material.EMERALD, XClaim.lang.getComponent("gui-comb-add")));
        this.setItem(23, DisplayItem.create(Material.BARRIER, XClaim.lang.getComponent("gui-comb-back")));
    }

    @Override
    public void onEnter() {
        this.populate();
    }

    @Override
    public void onExit() {
    }

    @Override
    public void onClick(int slot) {
        if (slot == 18) {
            --this.pageIndex;
            this.populate();
        } else if (slot == 26) {
            ++this.pageIndex;
            this.populate();
        } else if (slot == 23) {
            this.goBack();
        } else if (slot == 21) {
            this.prompt(XClaim.lang.get("gui-comb-prompt"), name -> {
                OfflinePlayer ply = NameToPlayer.getPlayer(name);
                if (ply == null) {
                    Platform.getAdventure().player(this.getTarget()).sendMessage(XClaim.lang.getComponent("gui-comb-prompt-fail"));
                    return;
                }
                this.add(ply);
                this.populate();
            });
        } else if (slot < 18) {
            OfflinePlayer ply = this.assoc.get(slot);
            if (ply != null) {
                this.onSelect(ply);
            }
            if (this.getParent().isOpen() && this.getParent().getActivePage() == this) {
                this.populate();
            }
        }
    }

    @NotNull
    protected abstract List<OfflinePlayer> getList();

    protected abstract void add(@NotNull OfflinePlayer var1);

    protected abstract void remove(@NotNull OfflinePlayer var1);

    protected abstract void onSelect(@NotNull OfflinePlayer var1);

    protected void goBack() {
        this.switchPage(new MainPage(this.getParent()));
    }
}

