/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui.page;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.event.XClaimDeleteClaimEvent;
import codes.wasabi.xclaim.api.event.XClaimEvent;
import codes.wasabi.xclaim.gui.ChunkEditor;
import codes.wasabi.xclaim.gui.GUIHandler;
import codes.wasabi.xclaim.gui.Page;
import codes.wasabi.xclaim.gui.page.ClaimSelectorPage;
import codes.wasabi.xclaim.gui.page.ClearAllPage;
import codes.wasabi.xclaim.gui.page.NewClaimPage;
import codes.wasabi.xclaim.gui.page.PermissionPage;
import codes.wasabi.xclaim.gui.page.PlayerCombinatorPage;
import codes.wasabi.xclaim.gui.page.TransferPage;
import codes.wasabi.xclaim.gui.page.VersionInfoPage;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import codes.wasabi.xclaim.util.DisplayItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MainPage
extends Page {
    private static final int NEW_POS = 11;
    private static final ItemStack NEW_STACK = DisplayItem.create(Material.NETHER_STAR, XClaim.lang.getComponent("gui-main-new"));
    private static final int EDIT_TRUST_POS = 12;
    private static final ItemStack EDIT_TRUST_STACK = DisplayItem.create(Platform.get().getSkeletonSkullMaterial(), XClaim.lang.getComponent("gui-main-edit-trust"));
    private static final int EDIT_CHUNK_POS = 13;
    private static final ItemStack EDIT_CHUNK_STACK = DisplayItem.create(Platform.get().getCraftingTableMaterial(), XClaim.lang.getComponent("gui-main-edit-chunk"));
    private static final int RENAME_CHUNK_POS = 14;
    private static final ItemStack RENAME_CHUNK_STACK = DisplayItem.create(Material.NAME_TAG, XClaim.lang.getComponent("gui-main-rename-chunk"));
    private static final int EDIT_PERM_POS = 15;
    private static final ItemStack EDIT_PERM_STACK = DisplayItem.create(Platform.get().getShieldMaterial(), XClaim.lang.getComponent("gui-main-edit-perm"));
    private static final int TRANSFER_OWNER_POS = 20;
    private static final ItemStack TRANSFER_OWNER_STACK = DisplayItem.create(Platform.get().getChestMinecartMaterial(), XClaim.lang.getComponent("gui-main-transfer-owner"));
    private static final int CLEAR_ALL_POS = 21;
    private static final ItemStack CLEAR_ALL_STACK = DisplayItem.create(Material.TNT, XClaim.lang.getComponent("gui-main-clear-all"));
    private static final int DELETE_POS = 22;
    private static final ItemStack DELETE_STACK = DisplayItem.create(Material.BARRIER, XClaim.lang.getComponent("gui-main-delete"));
    private static final int VERSION_POS = 23;
    private static final ItemStack VERSION_STACK = DisplayItem.create(Platform.get().getEnchantingTableMaterial(), XClaim.lang.getComponent("gui-main-version"));
    private static final int EXIT_POS = 24;
    private static final ItemStack EXIT_STACK = DisplayItem.create(Material.ARROW, XClaim.lang.getComponent("gui-main-exit"));
    private static final Map<Integer, ItemStack> assoc = new HashMap<Integer, ItemStack>();

    public MainPage(@NotNull GUIHandler parent) {
        super(parent);
    }

    @Override
    public void onEnter() {
        this.clear();
        for (Map.Entry<Integer, ItemStack> entry : assoc.entrySet()) {
            this.setItem(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void onClick(int slot) {
        switch (slot) {
            case 11: {
                this.switchPage(new NewClaimPage(this.getParent()));
                break;
            }
            case 12: {
                this.switchPage(new PlayerCombinatorPage(this.getParent()){
                    private final XCPlayer me;
                    {
                        this.me = XCPlayer.of((OfflinePlayer)this.getTarget());
                    }

                    @Override
                    @NotNull
                    protected List<OfflinePlayer> getList() {
                        return this.me.getTrustedPlayers();
                    }

                    @Override
                    protected void add(@NotNull OfflinePlayer ply) {
                        this.me.trustPlayer(ply);
                    }

                    @Override
                    protected void remove(@NotNull OfflinePlayer ply) {
                        this.me.untrustPlayer(ply);
                    }

                    @Override
                    protected void onSelect(@NotNull OfflinePlayer ply) {
                        this.remove(ply);
                    }
                });
                break;
            }
            case 13: {
                this.switchPage(new ClaimSelectorPage(this.getParent(), claim -> {
                    Player ply = this.getTarget();
                    World w = ply.getWorld();
                    Audience audience = Platform.getAdventure().player(ply);
                    if (!XClaim.mainConfig.worlds().checkLists(w)) {
                        audience.sendMessage(XClaim.lang.getComponent("gui-edit-chunk-disallowed"));
                        return;
                    }
                    World cw = claim.getWorld();
                    if (cw != null && w != cw) {
                        audience.sendMessage(XClaim.lang.getComponent("gui-edit-chunk-fail"));
                        this.getParent().close();
                        return;
                    }
                    ChunkEditor.startEditing(ply, claim);
                    this.getParent().close();
                }));
                break;
            }
            case 14: {
                this.switchPage(new ClaimSelectorPage(this.getParent(), claim -> {
                    this.switchPage(this);
                    this.prompt(XClaim.lang.get("gui-rename-chunk-prompt"), name -> {
                        if (name.length() > 50) {
                            Platform.getAdventure().player(this.getTarget()).sendMessage(XClaim.lang.getComponent("gui-rename-chunk-fail"));
                        } else {
                            claim.setName((String)name);
                        }
                        this.switchPage(new MainPage(this.getParent()));
                    });
                }));
                break;
            }
            case 15: {
                this.switchPage(new ClaimSelectorPage(this.getParent(), claim -> this.switchPage(new PermissionPage(this.getParent(), (Claim)claim))));
                break;
            }
            case 20: {
                this.switchPage(new ClaimSelectorPage(this.getParent(), claim -> this.switchPage(new TransferPage(this.getParent(), (Claim)claim))));
                break;
            }
            case 21: {
                this.switchPage(new ClearAllPage(this.getParent()));
                break;
            }
            case 22: {
                this.switchPage(new ClaimSelectorPage(this.getParent(), c -> {
                    Player ply = this.getTarget();
                    if (!XClaimEvent.dispatch(new XClaimDeleteClaimEvent(ply, (Claim)c))) {
                        this.getParent().close();
                        return;
                    }
                    c.unclaim();
                }){

                    @Override
                    protected boolean showClaim(@NotNull Claim claim, @NotNull OfflinePlayer ply) {
                        return claim.hasPermission(ply, Permission.DELETE);
                    }
                });
                break;
            }
            case 23: {
                this.switchPage(new VersionInfoPage(this.getParent()));
                break;
            }
            case 24: {
                this.getParent().close();
            }
        }
    }

    static {
        assoc.put(11, NEW_STACK);
        assoc.put(12, EDIT_TRUST_STACK);
        assoc.put(13, EDIT_CHUNK_STACK);
        assoc.put(14, RENAME_CHUNK_STACK);
        assoc.put(15, EDIT_PERM_STACK);
        assoc.put(20, TRANSFER_OWNER_STACK);
        assoc.put(21, CLEAR_ALL_STACK);
        assoc.put(22, DELETE_STACK);
        assoc.put(23, VERSION_STACK);
        assoc.put(24, EXIT_STACK);
    }
}

