/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui.page;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.gui.GUIHandler;
import codes.wasabi.xclaim.gui.Page;
import codes.wasabi.xclaim.gui.page.MainPage;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.util.ChunkReference;
import codes.wasabi.xclaim.util.DisplayItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ClaimSelectorPage
extends Page {
    private final Consumer<Claim> cb;
    private int pageIndex = 0;
    private Comparator<Claim> sorter = Comparator.comparing(Claim::getName, Comparator.naturalOrder());
    private final Map<Integer, Claim> slotAssoc = new HashMap<Integer, Claim>();

    public ClaimSelectorPage(@NotNull GUIHandler parent, @NotNull Consumer<Claim> callback) {
        super(parent);
        this.cb = callback;
    }

    protected boolean showClaim(@NotNull Claim claim, @NotNull OfflinePlayer ply) {
        return claim.hasPermission(ply, Permission.MANAGE);
    }

    private void populate() {
        this.clear();
        this.slotAssoc.clear();
        Player target = this.getTarget();
        List claims = Claim.getByOwner((OfflinePlayer)this.getTarget()).stream().sorted(this.sorter).collect(Collectors.toCollection(ArrayList::new));
        Claim.getAll().stream().filter(c -> !claims.contains(c) && this.showClaim((Claim)c, (OfflinePlayer)target)).sorted(this.sorter).forEach(claims::add);
        Claim within = Claim.getByChunk(target.getLocation().getChunk());
        boolean addedWithin = false;
        if (within != null && this.showClaim(within, (OfflinePlayer)target)) {
            addedWithin = true;
            claims.remove(within);
            claims.add(0, within);
        }
        int maxPage = Math.max((claims.size() - 1) / 24, 0);
        this.pageIndex = Math.min(Math.max(this.pageIndex, 0), maxPage);
        int i = this.pageIndex * 24;
        block0: for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 8; ++x) {
                Component name;
                if (i >= claims.size()) break block0;
                int idx = this.getPageIndex(x, y);
                Claim claim = (Claim)claims.get(i);
                XCPlayer owner = claim.getOwner();
                Player ply = owner.getPlayer();
                if (ply != null) {
                    name = Platform.get().playerDisplayName(ply);
                } else {
                    String nm = owner.getName();
                    if (nm == null) {
                        nm = owner.getUniqueId().toString();
                    }
                    name = Component.text(nm);
                }
                this.slotAssoc.put(idx, claim);
                ArrayList<Component> lore = new ArrayList<Component>();
                lore.add(XClaim.lang.getComponent("gui-sel-owned", name));
                Set<ChunkReference> chunks = claim.getChunks();
                int chunkCount = chunks.size();
                if (chunkCount == 1) {
                    lore.add(XClaim.lang.getComponent("gui-sel-chunk-count", chunkCount));
                } else {
                    lore.add(XClaim.lang.getComponent("gui-sel-chunk-count-plural", chunkCount));
                }
                if (chunkCount > 0) {
                    ChunkReference c2 = chunks.iterator().next();
                    Location bl = c2.getLocation(8.0, Platform.get().getWorldMinHeight(c2.world), 8.0);
                    lore.add(XClaim.lang.getComponent("gui-sel-first-chunk", bl.getBlockX(), bl.getBlockZ()));
                }
                if (i == 0 && addedWithin) {
                    lore.add(XClaim.lang.getComponent("gui-sel-within"));
                }
                this.setItem(idx, DisplayItem.create(Platform.get().getGreenToken(), Component.text(claim.getName()).color(NamedTextColor.GREEN), lore));
                ++i;
            }
        }
        if (this.pageIndex > 0) {
            this.setItem(8, DisplayItem.create(Material.ARROW, XClaim.lang.getComponent("gui-sel-previous")));
        } else {
            this.setItem(8, DisplayItem.create(Platform.get().getSpyglassMaterial(), XClaim.lang.getComponent("gui-sel-search")));
        }
        this.setItem(17, DisplayItem.create(Material.BARRIER, XClaim.lang.getComponent("gui-sel-cancel")));
        if (this.pageIndex < maxPage) {
            this.setItem(26, DisplayItem.create(Material.ARROW, XClaim.lang.getComponent("gui-sel-next")));
        }
    }

    @Override
    public void onEnter() {
        this.populate();
    }

    @Override
    public void onClick(int slot) {
        if (slot == 17) {
            this.switchPage(new MainPage(this.getParent()));
        } else if (slot == 8) {
            if (this.pageIndex > 0) {
                --this.pageIndex;
                this.populate();
            } else {
                this.prompt(XClaim.lang.get("gui-sel-prompt"), term -> {
                    this.sorter = Comparator.comparingInt(claim -> LevenshteinDistance.getDefaultInstance().apply(claim.getName(), (CharSequence)term));
                    this.populate();
                });
            }
        } else if (slot == 26) {
            ++this.pageIndex;
            this.populate();
        } else {
            Claim claim = this.slotAssoc.get(slot);
            if (claim != null) {
                this.cb.accept(claim);
                if (Objects.equals(this.getParent().getActivePage(), this) && this.getParent().isOpen()) {
                    this.populate();
                }
            }
        }
    }
}

