/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.gui;

import codes.wasabi.xclaim.gui.GUIHandler;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.TextComponent;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.TextDecoration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Page {
    private final GUIHandler parent;
    protected boolean suspended = false;
    private String awaitPrompt;
    private Consumer<String> awaitCallback;
    private boolean awaiting = false;

    public Page(@NotNull GUIHandler parent) {
        this.parent = parent;
    }

    @NotNull
    public final GUIHandler getParent() {
        return this.parent;
    }

    public abstract void onEnter();

    public void onExit() {
        if (this.awaiting) {
            this.awaitCallback = s -> {};
        }
        this.awaiting = false;
    }

    public void onClick(int slot) {
    }

    public boolean onMessage(@NotNull String message) {
        if (this.awaiting) {
            this.awaitCallback.accept(message);
            this.awaiting = false;
            return true;
        }
        return false;
    }

    public void onTick() {
        if (this.awaiting) {
            Audience audience = Platform.getAdventure().player(this.getTarget());
            audience.sendActionBar(((TextComponent)Component.text(this.awaitPrompt).color(NamedTextColor.WHITE)).decoration(TextDecoration.ITALIC, false));
        }
    }

    protected final void prompt(@NotNull String prompt, @NotNull Consumer<String> callback) {
        boolean ticking = this.parent.getShouldTick();
        this.parent.setShouldTick(true);
        this.suspend();
        Player target = this.getTarget();
        target.playSound(target.getLocation(), Platform.get().getExpSound(), 1.0f, 1.0f);
        this.awaitPrompt = prompt;
        this.awaitCallback = s -> {
            this.awaiting = false;
            this.parent.setShouldTick(ticking);
            Platform.get().getScheduler().synchronize(() -> {
                this.unsuspend();
                callback.accept((String)s);
            });
        };
        this.awaiting = true;
    }

    @NotNull
    protected final CompletableFuture<String> prompt(@NotNull String prompt) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        this.prompt(prompt, future::complete);
        return future;
    }

    protected final void switchPage(@Nullable Page newPage) {
        this.parent.switchPage(newPage);
    }

    @NotNull
    protected final Player getTarget() {
        return this.parent.getTarget();
    }

    protected final int getPageIndex(int x, int y) {
        return y * 9 + x;
    }

    protected final int[] getCoordinates(int index) {
        int x = index % 9;
        int y = (index - x) / 9;
        return new int[]{x, y};
    }

    protected final void setItem(int index, @Nullable ItemStack is) {
        this.parent.getInventory().setItem(index, is);
    }

    protected final void setItem(int x, int y, @Nullable ItemStack is) {
        this.parent.getInventory().setItem(this.getPageIndex(x, y), is);
    }

    @Nullable
    protected final ItemStack getItem(int index) {
        return this.parent.getInventory().getItem(index);
    }

    @Nullable
    protected final ItemStack getItem(int x, int y) {
        return this.parent.getInventory().getItem(this.getPageIndex(x, y));
    }

    protected final void clear() {
        this.parent.getInventory().clear();
    }

    protected final void suspend(boolean suspend) {
        if (this.suspended == suspend) {
            return;
        }
        if (suspend) {
            this.suspended = true;
            Inventory iv = this.parent.getInventory();
            Platform.get().closeInventory(iv);
        } else {
            this.parent.getTarget().openInventory(this.parent.getInventory());
            this.suspended = false;
        }
    }

    protected final void suspend() {
        this.suspend(true);
    }

    protected final void unsuspend() {
        this.suspend(false);
    }
}

