/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.economy.impl;

import codes.wasabi.xclaim.economy.Economy;
import java.math.BigDecimal;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;

public class VaultEconomy
extends Economy {
    private final net.milkbowl.vault.economy.Economy eco;

    public VaultEconomy() {
        RegisteredServiceProvider rsp = Objects.requireNonNull(Bukkit.getServer().getServicesManager().getRegistration(net.milkbowl.vault.economy.Economy.class));
        this.eco = Objects.requireNonNull((net.milkbowl.vault.economy.Economy)rsp.getProvider());
    }

    @Override
    public boolean canAfford(OfflinePlayer ply, BigDecimal amount) {
        return this.eco.has(ply, amount.doubleValue());
    }

    @Override
    public boolean give(OfflinePlayer ply, BigDecimal amount) {
        return this.eco.depositPlayer(ply, amount.doubleValue()).transactionSuccess();
    }

    @Override
    public boolean take(OfflinePlayer ply, BigDecimal amount) {
        return this.eco.withdrawPlayer(ply, amount.doubleValue()).transactionSuccess();
    }

    @Override
    @NotNull
    public String format(BigDecimal amount) {
        return this.eco.format(amount.doubleValue());
    }
}

