/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.economy.impl;

import codes.wasabi.xclaim.economy.Economy;
import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import com.earth2me.essentials.api.NoLoanPermittedException;
import java.math.BigDecimal;
import net.ess3.api.MaxMoneyException;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class EssentialsEconomy
extends Economy {
    private final Essentials ess = (Essentials)Essentials.getPlugin(Essentials.class);

    public EssentialsEconomy() throws Exception {
        Class.forName("com.earth2me.essentials.api.Economy");
    }

    private User getUser(OfflinePlayer ply) {
        if (ply.isOnline() && ply instanceof Player) {
            return this.ess.getUser((Player)ply);
        }
        return this.ess.getUser(ply.getUniqueId());
    }

    @Override
    public boolean canAfford(OfflinePlayer ply, BigDecimal amount) {
        return com.earth2me.essentials.api.Economy.hasEnough((User)this.getUser(ply), (BigDecimal)amount);
    }

    @Override
    public boolean give(OfflinePlayer ply, BigDecimal amount) {
        try {
            com.earth2me.essentials.api.Economy.add((User)this.getUser(ply), (BigDecimal)amount);
        }
        catch (NoLoanPermittedException | ArithmeticException | MaxMoneyException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean take(OfflinePlayer ply, BigDecimal amount) {
        try {
            com.earth2me.essentials.api.Economy.subtract((User)this.getUser(ply), (BigDecimal)amount);
        }
        catch (NoLoanPermittedException | ArithmeticException | MaxMoneyException e) {
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String format(BigDecimal amount) {
        return com.earth2me.essentials.api.Economy.format((BigDecimal)amount);
    }
}

