/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.debug.writer;

import codes.wasabi.xclaim.debug.writer.DebugWriter;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.TextColor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

abstract class AbstractDebugWriter
implements DebugWriter {
    private TextColor color = NamedTextColor.WHITE;

    AbstractDebugWriter() {
    }

    @Override
    public void color(@NotNull TextColor color) {
        this.color = color;
    }

    @Override
    public void println(@NotNull CharSequence text) {
        this.println(text, this.color);
    }

    protected abstract void println(@NotNull CharSequence var1, @NotNull TextColor var2);

    @Override
    public void raise(@NotNull Throwable t) {
        String trace;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             OutputStreamWriter writer1 = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
             PrintWriter writer2 = new PrintWriter(writer1);){
            t.printStackTrace(writer2);
            writer2.flush();
            trace = new String(bos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String msg = t.getMessage();
            if (msg == null) {
                msg = "Unknown error";
            }
            this.println("* " + msg, NamedTextColor.DARK_RED);
            return;
        }
        for (String line : trace.split("\n")) {
            this.println("* " + line, NamedTextColor.RED);
        }
    }
}

