/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.debug;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.debug.Debuggable;
import codes.wasabi.xclaim.debug.goal.DebugGoalInstance;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reflections.Reflections;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;

@ApiStatus.Internal
public final class Debug {
    private static final String PACKAGE_PREFIX_SLASH = "codes/wasabi/xclaim";
    private static final String PACKAGE_PREFIX_DOT = "codes.wasabi.xclaim";
    private static final int PACKAGE_PREFIX_LENGTH = 19;
    private static final File CODE_SOURCE;
    private static final boolean ENABLED;
    private static List<DebugGoalInstance> GOALS;

    public static boolean isEnabled() {
        return ENABLED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<DebugGoalInstance> getGoals() {
        if (!ENABLED) {
            return Collections.emptyList();
        }
        Class<Debug> clazz = Debug.class;
        synchronized (Debug.class) {
            if (GOALS != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return GOALS;
            }
            ArrayList<DebugGoalInstance> ret = new ArrayList<DebugGoalInstance>();
            try {
                Debug.getGoals0(Debug.getPackageList(), ret);
            }
            catch (IOException | ReflectiveOperationException e) {
                XClaim.logger.log(Level.WARNING, "Failed to perform reflection for debug goals", e);
            }
            GOALS = Collections.unmodifiableList(ret);
            // ** MonitorExit[var0] (shouldn't be in output)
            return GOALS;
        }
    }

    private static void getGoals0(@NotNull String[] packageList, @NotNull List<DebugGoalInstance> list) throws IOException, ReflectiveOperationException {
        Reflections reflections = new Reflections(new ConfigurationBuilder().forPackages(packageList).setScanners(Scanners.TypesAnnotated));
        for (Class<?> cls : reflections.getTypesAnnotatedWith(Debuggable.class)) {
            list.addAll(DebugGoalInstance.findInClass(cls));
        }
    }

    private static String[] getPackageList() throws IOException {
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        try (FileInputStream fis = new FileInputStream(CODE_SOURCE);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry ze;
            StringBuilder sb = new StringBuilder(PACKAGE_PREFIX_DOT);
            while ((ze = zis.getNextEntry()) != null) {
                String name;
                if (!ze.isDirectory() || !(name = ze.getName()).startsWith(PACKAGE_PREFIX_SLASH)) continue;
                boolean queueDot = false;
                for (int i = 19; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (c == '/') {
                        queueDot = true;
                        continue;
                    }
                    if (queueDot) {
                        sb.append('.');
                        queueDot = false;
                    }
                    sb.append(c);
                }
                packages.add(sb.toString());
                sb.setLength(19);
            }
        }
        int count = packages.size();
        String[] ret = new String[count];
        int head = 0;
        for (String pkg : packages) {
            ret[head++] = pkg;
        }
        return ret;
    }

    @Nullable
    public static DebugGoalInstance getGoalByLabel(@NotNull String label) {
        for (DebugGoalInstance instance : Debug.getGoals()) {
            if (!instance.label().equalsIgnoreCase(label)) continue;
            return instance;
        }
        return null;
    }

    static {
        boolean enabled;
        block24: {
            GOALS = null;
            CODE_SOURCE = new File(Debug.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            enabled = false;
            Pattern regex = Pattern.compile("^Enable-Debug:\\s*(true|false)$", 2);
            try (ZipFile zf = new ZipFile(CODE_SOURCE);){
                ZipEntry ze = zf.getEntry("META-INF/MANIFEST.MF");
                if (ze == null) break block24;
                try (InputStream is = zf.getInputStream(ze);
                     InputStreamReader reader1 = new InputStreamReader(is, StandardCharsets.UTF_8);
                     BufferedReader reader2 = new BufferedReader(reader1);){
                    String line;
                    while ((line = reader2.readLine()) != null) {
                        Matcher m = regex.matcher(line);
                        if (!m.matches()) continue;
                        enabled = m.group(1).equalsIgnoreCase("true");
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ENABLED = enabled;
    }
}

