/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.config.impl.yaml;

import codes.wasabi.xclaim.config.impl.yaml.YamlConfig;
import codes.wasabi.xclaim.config.impl.yaml.helpers.YamlLimits;
import codes.wasabi.xclaim.config.impl.yaml.sub.YamlAutoSaveConfig;
import codes.wasabi.xclaim.config.impl.yaml.sub.YamlDefaultPermissionsConfig;
import codes.wasabi.xclaim.config.impl.yaml.sub.YamlEditorConfig;
import codes.wasabi.xclaim.config.impl.yaml.sub.YamlGuiConfig;
import codes.wasabi.xclaim.config.impl.yaml.sub.YamlIntegrationsConfig;
import codes.wasabi.xclaim.config.impl.yaml.sub.YamlRulesConfig;
import codes.wasabi.xclaim.config.impl.yaml.sub.YamlWorldsConfig;
import codes.wasabi.xclaim.config.struct.RootConfig;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public final class YamlRootConfig
extends YamlConfig
implements RootConfig {
    private final YamlAutoSaveConfig autoSave;
    private final YamlEditorConfig editor;
    private final YamlRulesConfig rules;
    private final YamlWorldsConfig worlds;
    private final YamlIntegrationsConfig integrations;
    private final YamlGuiConfig gui;
    private final YamlDefaultPermissionsConfig defaultPermissions;

    public YamlRootConfig(@NotNull ConfigurationSection section) {
        super(section);
        YamlLimits limits = YamlLimits.of(this.getSection("limits"));
        this.autoSave = new YamlAutoSaveConfig(this.getSection("auto-save"));
        this.editor = new YamlEditorConfig(section);
        this.rules = new YamlRulesConfig(section, limits);
        this.worlds = new YamlWorldsConfig(this.getSection("worlds"));
        this.integrations = new YamlIntegrationsConfig(section, limits);
        this.gui = new YamlGuiConfig();
        this.defaultPermissions = new YamlDefaultPermissionsConfig();
    }

    @Override
    public @UnknownNullability String language() {
        return this.getString("language");
    }

    @Override
    public @UnknownNullability Long veteranTime() {
        return this.getLong("veteran-time");
    }

    @Override
    public @UnknownNullability Boolean noPaperNag() {
        return this.getBoolean("disable-paper-warning");
    }

    @Override
    @NotNull
    public YamlAutoSaveConfig autoSave() {
        return this.autoSave;
    }

    @Override
    @NotNull
    public YamlEditorConfig editor() {
        return this.editor;
    }

    @Override
    @NotNull
    public YamlRulesConfig rules() {
        return this.rules;
    }

    @Override
    @NotNull
    public YamlWorldsConfig worlds() {
        return this.worlds;
    }

    @Override
    @NotNull
    public YamlIntegrationsConfig integrations() {
        return this.integrations;
    }

    @Override
    @NotNull
    public YamlGuiConfig gui() {
        return this.gui;
    }

    @Override
    @NotNull
    public YamlDefaultPermissionsConfig defaultPermissions() {
        return this.defaultPermissions;
    }

    @Override
    public boolean isLegacy() {
        return true;
    }
}

