/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.config.impl.yaml;

import codes.wasabi.xclaim.config.struct.Config;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class YamlConfig
implements Config {
    protected final ConfigurationSection section;
    protected final boolean valid;

    protected YamlConfig(@Nullable ConfigurationSection section) {
        this.section = section;
        this.valid = section != null;
    }

    @NotNull
    protected final ConfigurationSection raw() {
        if (this.valid) {
            return Objects.requireNonNull(this.section);
        }
        return new YamlConfiguration();
    }

    @Nullable
    protected final ConfigurationSection getSection(@NotNull String key) {
        if (this.valid) {
            return this.raw().getConfigurationSection(key);
        }
        return null;
    }

    @Override
    @Nullable
    public Config sub(@NotNull String key) {
        return new YamlConfig(this.getSection(key));
    }

    @Override
    @Nullable
    public final String getString(@NotNull String key) {
        return this.extract(key, section -> section.getString(key));
    }

    @Override
    @Nullable
    public final Boolean getBoolean(@NotNull String key) {
        return this.extract(key, section -> section.getBoolean(key));
    }

    @Override
    @Nullable
    public final Integer getInt(@NotNull String key) {
        return this.extract(key, section -> section.getInt(key));
    }

    @Override
    @Nullable
    public final Long getLong(@NotNull String key) {
        return this.extract(key, section -> section.getLong(key));
    }

    @Nullable
    private <T> T extract(@NotNull String key, @NotNull Function<ConfigurationSection, T> extractor) {
        if (!this.valid) {
            return null;
        }
        ConfigurationSection raw = this.raw();
        if (!raw.contains(key)) {
            return null;
        }
        return extractor.apply(raw);
    }
}

