/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.config.impl.toml.helpers;

import codes.wasabi.xclaim.shadow.toml.Toml;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TomlGroupableValue<T> {
    private final int mode;
    private final Object value;
    private final Set<String> keys;

    public TomlGroupableValue(@Nullable Toml table, @NotNull String key) {
        int mode = 0;
        Toml value = null;
        LinkedHashSet<String> keys = null;
        if (table != null) {
            Toml sub;
            if (table.containsTable(key) && (sub = table.getTable(key)) != null) {
                mode = 1;
                value = sub;
                Set<Map.Entry<String, Object>> entries = sub.entrySet();
                keys = new LinkedHashSet<String>(entries.size());
                for (Map.Entry<String, Object> entry : entries) {
                    keys.add(entry.getKey());
                }
            } else {
                T t = this.extract(table, key);
                value = (Toml)t;
                if (t != null) {
                    mode = 2;
                }
            }
        }
        this.mode = mode;
        this.value = value;
        this.keys = keys;
    }

    @Nullable
    protected abstract T extract(@NotNull Toml var1, @NotNull String var2);

    @Contract(value="null -> null; !null -> !null")
    protected abstract T cast(Object var1);

    protected abstract int compare(@NotNull T var1, @NotNull T var2);

    @Nullable
    public T get(@Nullable Permissible target) {
        if (this.mode == 1) {
            return this.getMode1(target, (Toml)this.value, this.keys);
        }
        if (this.mode == 2) {
            return this.cast(this.value);
        }
        return null;
    }

    @Nullable
    private T getMode1(@Nullable Permissible target, @NotNull Toml table, @NotNull Set<String> keys) {
        T ret = null;
        boolean any = false;
        for (String group : keys) {
            T next;
            if (!this.inGroup(target, group) || (next = this.extract(table, group)) == null) continue;
            if (any) {
                if (this.compare(next, ret) <= 0) continue;
                ret = next;
                continue;
            }
            ret = next;
            any = true;
        }
        return ret;
    }

    private boolean inGroup(@Nullable Permissible target, @NotNull String group) {
        if (group.equals("default")) {
            return true;
        }
        if (target == null) {
            return false;
        }
        if (target.isOp()) {
            return true;
        }
        return target.hasPermission("xclaim.group." + group);
    }

    public static final class Int
    extends TomlGroupableValue<Integer> {
        private final IntComparator comparator;

        public Int(@Nullable Toml table, @NotNull String key, @NotNull IntComparator comparator) {
            super(table, key);
            this.comparator = comparator;
        }

        @Override
        @Nullable
        protected Integer extract(@NotNull Toml table, @NotNull String key) {
            Long value;
            try {
                value = table.getLong(key);
            }
            catch (ClassCastException ignored) {
                return null;
            }
            if (value == null) {
                return null;
            }
            try {
                return Math.toIntExact(value);
            }
            catch (ArithmeticException ignored) {
                return null;
            }
        }

        @Override
        protected Integer cast(Object object) {
            return (Integer)object;
        }

        @Override
        protected int compare(@NotNull Integer a, @NotNull Integer b) {
            return this.comparator.compare(a.intValue(), b.intValue());
        }
    }
}

